
;;--------------------- dem.s ----------------------------------

;>>>
;>>> demon environment definition and access functions:
;>>>
;>>> 		all variables used by demons are defined in a separate 
;>>>		demon environment.  this is to solve another lexical
;>>>		vs. dynamic scoping problem.

;> set up the environment in which demon parameters and variables are 
;> 	defined 
(define demon-env (make-environment))

;> demon-set!: function to modify values of variables in the demon
;>		environment
(define (demon-set! var val)
  (set! (access var demon-env) val))

(define (demon-set-value! exp value) 
  (set-indirect! exp value demon-env))

;> demon-eval: evaluate the expression in the demon environment
(define (demon-eval exp) (eval exp demon-env))

