;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: ADVISOR -*-
;;; -----------------------------------------------------------------------
;;; File:         gr.l
;;; Description:  System file to load the grammar
;;; Author:       Michael Elhadad
;;; Created:      19 Dec 1991
;;; Modified    : 16 Jul 92 - added NP subtleties (partitive, measure...)
;;; Package:      ADVISOR
;;; -----------------------------------------------------------------------

;;; (in-package "ADVISOR")


(defun reload-gr ()
  "Reload all grammar"
  (let ((cur *default-pathname-defaults*)
	(*warn-if-no-in-package* nil))
    (cd "$fug5/grammar")
    (load "tpat")
    (load "types")
    (load "transitivity")
    (load "voice")
    (load "circumstance")
    (load "clause")
    (load "verb-group")
    (load "np")
    (load "complex")
    (load "determiner")
    (load "gr-modular")
    (cd cur)))

(defun load-gr ()
  "Load missing parts of the grammar"
  (let ((cur *default-pathname-defaults*)
	(*warn-if-no-in-package* nil))
    (cd "$fug5/grammar")
    ;; Utilities for temporal patterns  (tpattern unifier)
    (require "tpat" "tpat")
    (require "types" "types")
    (require "clause" "clause")
    (require "verb-group" "verb-group")
    (require "np" "np")
    (require "determiner" "determiner")
    (require "complex" "complex")
    (require "gr-modular" "gr-modular")
    (cd cur)))
  
(load-gr)

(defun compile-gr ()
  "Compile grammar"
  (let ((cur *default-pathname-defaults*)
	(*warn-if-no-in-package* nil))
    (cd "$fug5/grammar")
    (compile-file "tpat.l")
    (compile-file "types.l")
    (compile-file "transitivity.l")
    (compile-file "voice.l")
    (compile-file "circumstance.l")
    (compile-file "clause.l")
    (compile-file "verb-group.l")
    (compile-file "np.l")
    (compile-file "complex.l")
    (compile-file "determiner.l")
    (compile-file "gr-modular.l")
    (cd cur)))

;; ------------------------------------------------------------
(provide "$fug5/grammar/gr")
;; ------------------------------------------------------------
