;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: ADVISOR -*-
;;; ------------------------------------------------------------
;;; File        : GR-MODULAR.L
;;; Description : Update of gr.l:
;;;               For advisor system using def-alt.
;;; Author      : Michael Elhadad
;;; Created     : 18 Dec 91
;;; Modified    : 16 Jul 92 - added NP subtleties (partitive, measure...)
;;;               19 Aug 92 - added extended NP categories (JR)
;;; Language    : FUF5.0
;;; ------------------------------------------------------------

;;; (in-package "ADVISOR")

;; NOTE: all non-implemented features, or things to do are marked in
;; comments with a ***** sign.


;; ============================================================
;; GRAMMAR 
;; ============================================================

(defun surface (fd &optional trace)
  (if trace (trace-on) (trace-off))
  (if (eq trace :full) 
    (trace-enable-all (gr))
    (trace-disable-all (gr)))
  (uni fd 
       :grammar (gr)
       :cset-attribute 'cset
       :limit 2000))

(defun surface-fd (fd)
  (uni-fd fd 
       :grammar (gr)
       :cset-attribute 'cset
       :limit 2000))


(def-grammar gr ()
  ;; These are completely determined by the morphology features
  ;; they are not unified with the grammar
  (register-categories-not-unified 
   'cat
   '(verb punctuation prep conj relpro modal))

  (clear-bk-class)
  ;; (define-bk-class 'dative-move 'dative-move)

  (setf *any-at-unification* nil)

  (setq *realize-grammar* '((alt (:wait {^ cat}) 
   (

    ((cat ds)
     (alt simple (:index simple)
       (((simple yes)
	 (cset ((= pc)))
	 (pattern (pc)))
	((simple no)
	 (cset ((= connective directive subordinate)))
	 (alt connective 
	     (((connective none)
	       (subordinate none)
	       (pattern (directive)))
	      ((connective ((cat connective) (break-sentence no)))
	       (subordinate given)
	       (subordinate ((punctuation ((after ",")))))
	       (alt ds-order (:wait {^ connective order})
		 (:index (connective order))
		 (((connective ((order dcs)))
		   (pattern (directive connective subordinate)))
		  ((connective ((order scd)))
		   (pattern (subordinate connective directive))))))
	      ((connective ((cat connective) (break-sentence yes)))
	       (subordinate given)
	       (pattern (subordinate connective directive))
	       (connective ((punctuation ((capitalize yes)))))
	       (subordinate ((punctuation ((after "."))))))
	      ((connective sentence)
	       (subordinate given)
	       (pattern (subordinate directive))
	       (directive ((punctuation ((capitalize yes)))))
	       (subordinate ((punctuation ((after "."))))))))))))

    ((cat utterance)
     (cset ((= pc)))
     (pattern (pc)))

    ((cat connective)
     (pattern (head))
     (head ((lex {^2 lex}) (cat conj)))
     (alt connective-lex (:index (head lex))
       (((head ((lex "so"))) (order scd))
	((head ((lex "and"))) (order scd))
	((head ((lex "since"))) (order dcs))
	((head ((lex "because"))) (order dcs))
	((head ((lex "although"))) (order dcs))
	((head ((lex "but"))) (order scd))
	((head ((lex "therefore"))) (order scd)))))

    ;; first only simple constituents - complex follows
    ;;==============================================================
    ;; 01 CAT CLAUSE : clause --------------------------------------
    ;;==============================================================
    ((:& simple-clause)
     (cset ((- semr kind))))

    ;;==============================================================
    ;; 02 CAT VERB-GROUP -------------------------------------------
    ;;==============================================================
    ((:& simple-verb-group)
     (cset ((- semr kind))))

    ;;==============================================================
    ;; 03 CAT NP ---------------------------------------------------
    ;;==============================================================
    ;; If there is a gap in the constituent, don't do anything at all.
    ((cat #(under np))
     (alt np-gap (:ignore-when gap)
       (((gap none) 
	 (alt type-of-np (:index cat)
	   (((:& partitive))
	    ((:& trivial-proper)) ;; For proper nouns (no fuss, efficient)
	    ((:& measure))
	    ((:& simple-np)))))
	((gap #(under yes)))))
     (cset ((- semr kind))))

    ;;==============================================================
    ;; 031 CAT NP-HEAD ---------------------------------------------
    ;;==============================================================
    ((cat np-head)
     (cset ((- semr kind)))
     (complex none)
     (alt (((cat noun) (generic-cat noun))
	   ((:& noun-compound))
	   ((:& measure))
	   ((:& partitive))
	   ((:& person-name))
	   ((:& team-name)))))

    ;; ==============================================================
    ;; 04 CAT AP : for adjectival phrases ---------------------------
    ;; ==============================================================
    ;; ***** Do comparative constructs here
    ((cat simple-ap)
     (cset ((- semr kind)))
     (complex none)
     (generic-cat ap)
     (head ((cat adj)
	    (concept {^ ^ concept})
	    (polarity {^ ^ polarity})
	    (lex {^ ^ lex})))
     ;; "light blue" (light is the classifier)
     (alt (((classifier none))
	   ((classifier given)
	    (classifier ((cat ((alt (adj #(under np-head)))))
			 (synt-funct classifier))))))
     ;; "visible in the cutaway view" (qualifier)
     (alt (((qualifier none))
	   ((qualifier given)
	    (qualifier ((cat pp))))))
     ;; modifier is an adverb: can be intensifier or detensifier
     (alt (((modifier none))
	   ((modifier given)
	    (modifier ((cat adv))))))
     %ap%
     (pattern (modifier classifier head qualifier)))
      
    ;; ==============================================================
    ;; 05 CAT PP : for prepositional phrases ------------------------
    ;; ==============================================================
    ((cat simple-pp)
     (cset ((- semr kind)))
     (complex none)
     (generic-cat pp)
     (pattern (prep np))
     (prep ((cat prep) (lex given)))
     (np ((cat np))))

    ;;==============================================================
    ;; 06 CAT DET : for articles -----------------------------------
    ;;==============================================================
    ((:& det)
     (cset ((- semr kind))))


    ((:& fraction)
     (cset ((- semr kind))))


    ;; ==============================================================
    ;; 07 CAT LIST : for agglutinated constituents ------------------
    ;; ==============================================================
    ;; List is for an agglutination of heterogeneous constituents all
    ;; playing together the same syntactic function in a larger
    ;; constituent.
    ;; For example, a list of describers or qualifiers in an NP.
    ;; Each element of the list can be of a different cat (unlike
    ;; conjunction). 
    ;; Lists have one main feature:
    ;; elements: a list of features in car/cdr form (~ macro is useful).
    ;; Just recurse on all elements of the list with no additional processing
    ((cat list)
     (elements {^ distinct})  ;; for compatibility with complex
     (cset ((- semr kind)))
     (alt list 
       (:demo"How many elements are there in the list?")
       (((elements none))                           ;; 0 elements
	((elements ((car given) (cdr none)))        ;; 1 elements 
	 (first {^  elements car})
	 (cset (first))                 ;; to eliminate any others
	 (pattern (first)))
	((first {^  elements car})      ;; more 
	 (first given)
	 (rest ((cat list)
		(elements {^ ^ elements cdr})
		(elements given)))
	 (cset (first rest))  
	 (pattern (first rest))))))


    ;; ==============================================================
    ;; 08 CAT COMPLEX : for complex constituents --------------------
    ;; ==============================================================
    ((:& complex)
     (cset ((- semr kind))))

    ;; ==============================================================
    ;; 09 CAT SET : for semantic description of sets ----------------
    ;; ==============================================================
    ;; ((:& set))
    ((cat set))

    ((cat adj)
     (cset ((- semr kind))))

    ((cat adv)
     (generic-cat adv)
     (cset ((- semr kind)))
     (complex none)
     (alt adv-type (:index cat)
       (((cat #(under detensifier))
	 (lex ((ralt ("quite" "pretty" "rather" "somehow")))))
	((cat #(under intensifier))
	 (lex ((ralt ("very" "extremely")))))
	((cat adv)))))

    ;; ==============================================================
    ;; Misc categories ignored by the grammar and recognized by the
    ;; morphology component.
    ((cat phrase) (cset ((- semr kind))))
    ((cat article))
    ((cat pronoun))

    ((cat cardinal)
     ;; Stylistic rule: numbers less than 10 in letters, others in digits.
     (alt cardinal-value 
	 (((value given)
	   (control (and (integerp #@{^ value})
			 (> #@{^ value} 0) 
			 (< #@{^ value} 11)))
	   (digit no))
	  ((digit yes))
	  ((digit #(under roman))))))

    ((cat ordinal)
     (alt (((value given)
	    (control (and (integerp #@{^ value})
			  (> #@{^ value} 0) 
			  (< #@{^ value} 11)))
	    (digit no))
	   ((value +)
	    (lex ((ralt ("next" "following" "subsequent")))))
	   ((value -)
	    (lex ((ralt ("preceding")))))
	   ((value <>)
	    (lex "other"))
	   ((value last)
	    (lex "last"))
	   ((digit yes))
	   ((digit #(under roman))))))

    ;; ============================================================
    ;; Domain dependent categories.
    ((cat score)
     (hi ((cat cardinal)
	  (digit yes)
	  (value {^ ^ win})))
     (lo ((cat cardinal)
	  (digit yes)
	  (value {^ ^ lose})))
     (to ((cat phrase)
	  (lex "-")))
     (pattern (hi to lo)))

    )))))


(gr)


;; ============================================================
(provide "gr-modular")
;; ============================================================
