;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: ADVISOR -*-
;;; -----------------------------------------------------------------------
;;; File:         connectives.l
;;; Description:  Connective grammar using topoi relations
;;; Author:       Michael Elhadad
;;; Created:      10 Nov 1992
;;; Modified:     
;;; Package:      ADVISOR
;;; -----------------------------------------------------------------------

;;; (in-package "ADVISOR")

;;; Define arg-link as a bk-class.
;;; Note the distinction topos/topoi.
;;; Cat topoi is used to check that a pair of evaluations is in
;;; argumentative relation according to the topoi-base.
;;; cat topos is used to represent the ao of a DS.
;;; (hack, to some extent, but the two functions are distinct).
;;; A topoi has features: left, right.
;;; left and right are evaluations: scale, orientation, evaluated.

(def-conj connective
  ;; Contrast or support connective ?
  ;; 1. Normalize the ao of directive and subordinate to be a single
  ;; scale.
  (cset ((- arg-link)))

  (alt normalize-connective-d (:index (directive ao cat))
    (:wait {^ directive ao cat})
    (((directive ((ao none))))
     ((directive ((ao ((cat evaluation)))))
      (dscale ((scale {^2 directive ao scale})
	       (evaluated {^2 directive ao scale evaluated})
	       (orientation+ {^2 directive ao scale orientation}))))
     ((directive ((ao ((cat topos)))))
      (dscale ((scale {^2 directive ao right scale})
	       (evaluated {^2 directive ao right evaluated})
	       (orientation+ {^2 directive ao right orientation}))))))

  (alt normalize-connective-s (:index (subordinate ao cat))
    (:wait {^ subordinate ao cat})
    (((subordinate ((ao none)))
      (alt subordinate-ao-embedded (:index (subordinate directive ao cat))
	(:wait {^ subordinate directive ao cat})
	(((subordinate ((directive ((ao none))))))
	 ((subordinate ((directive ((ao ((cat evaluation)))))))
	  (sscale ((scale {^2 subordinate directive ao scale})
		   (evaluated {^2 subordinate directive ao evaluated})
		   (orientation+ {^2 subordinate directive ao orientation}))))
	 ((subordinate ((directive ((ao ((cat topos)))))))
	  (sscale
	   ((orientation+ {^2 subordinate directive ao right orientation})
	    (evaluated {^2 subordinate directive ao right evaluated})
	    (scale {^2 subordinate directive ao right scale})))))))
     ((subordinate ((ao ((cat evaluation)))))
      (sscale ((orientation+ {^2 subordinate ao orientation})
	       (evaluated {^2 subordinate ao evaluated})
	       (scale {^2 subordinate ao scale}))))
     ((subordinate ((ao ((cat topos)))))
      (sscale ((orientation+ {^2 subordinate ao right orientation})
	       (evaluated {^2 subordinate ao right evaluated})
	       (scale {^2 subordinate ao right scale}))))))

  ;; Compare ao of d and s: support if there is topos (+s/+d)
  (alt support-or-contrast (:bk-class arg-link)
    (:wait (sscale dscale))
    (
     ;; exist t(+s/+d)
     ((lex-cset ((+ arg-link)))
      (arg-link ((cat topoi)
		 (type support)
		 (left {^2 sscale})
		 (left ((orientation {^ orientation+})))
		 (right {^2 dscale})
		 (right ((orientation {^ orientation+}))))))

     ;; exist t(+s/-d) (-d is opposite sign from d, eg, if d is -take, -d
     ;; is +take).
     ((lex-cset ((+ arg-link)))
      (arg-link ((cat topoi)
		 (type direct-contrast)
		 (left {^2 sscale})
		 (left ((orientation {^ orientation+})))
		 (right {^2 dscale})
		 (alt (((right ((orientation+ +)
				(orientation -))))
		       ((right ((orientation+ -)
				(orientation +)))))))))

     ;; exist t1(+s/+c) t2(+d/-c)
     ((lex-cset ((+ {^ arg-link 1} {^ arg-link 2})))
      (arg-link ((type indirect-contrast)
		 (1 ((cat topoi)
		     (tautology no)
		     (left {^3 sscale})
		     (left ((orientation {^ orientation+})))))
		 (2 ((cat topoi)
		     (tautology no)
		     (left {^3 dscale})
		     (left ((orientation {^ orientation+})))
		     (right ((evaluated {^3 1 right evaluated})
			     (scale {^3 1 right scale})
			     (alt (((orientation +)
				    ({^2 1 right orientation} -))
				   ((orientation -)
				    ({^2 1 right orientation} +)))))))))))
     ((arg-link none))))

  ;; Choose connective based on arg-link
  (alt connective-lex (:index (arg-link type))
    (:wait arg-link)
    (((arg-link none)
      (lex "and"))
     ((arg-link ((type support)))
      (lex ((ralt ("so" "therefore" "because")))))
     ((arg-link ((type direct-contrast)))
      (lex ((ralt ("although" "but")))))
     ((arg-link ((type indirect-contrast)))
      (lex "but"))))
  )




;; ------------------------------------------------------------
(provide "connectives")
;; ------------------------------------------------------------
