;;
;;
;;      Title : maload
;;
;;      Function : This defines the bootstrap function for the morphological
;;                 analyser system
;;
;;      Author :  Alan W Black   28th Oct 1985
;;                Dept of A.I.   University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;      Description :
;;          This function when called loads the rest of the analyser and
;;          dictionary access code from the given directory.  Also the
;;          system is initialised by calling the D-Initialise function.
;;
;;      Parameters :
;;        directory :  optional, the name of the directory where the
;;                     code is.
;;      Returns :
;;                    t  if code loaded, otherwise an error is signalled
;;      Side Effect :
;;          loads the functions for the dictionary and analyser system
;;          and initialises the global variables.
;;
;;      External references :
;;
;;      System functions used :
;;        Name     type      Args #  type                 Comment
;;
;;      Restrictions :
;;
;;

(defun d-maload  (&rest args)
;;
;;
;;  this function loads the basic analyser files from the given directory
;;  if directory is not given the current directory (or in the 
;;  status variable load-search-path).  This also initialises the 
;;  dictionary system.
;;
   (cond
      ((and args (atom (car args)))
	 (load (concat (car args) "/makesp"))
	 (load (concat (car args) "/mkwgram"))
	 (load (concat (car args) "/makelex"))
	 (load (concat (car args) "/mafuncs"))
	 (load (concat (car args) "/analyse"))
	 (load (concat (car args) "/autorun"))
	 (load (concat (car args) "/mconcat"))
	 (load (concat (car args) "/spdebug"))
	 (load (concat (car args) "/debug"))
      )
      ((null args)              ;; no directory given
         (load "makesp")        ;; compile spelling rules
         (load "mkwgram")       ;; compile word grammar
         (load "makelex")       ;; compile dictionary
	 (load "mafuncs")       ;; some of the basic files
         (load "analyse")       ;; morpho-parser
         (load "autorun")       ;; morphographemic-analyser
	 (load "mconcat")       ;; surface form generator
	 (load "spdebug")       ;; spelling rule debugger
	 (load "debug")         ;; debugger for parses   
      )
      (t
         (error "directory not specified as atom")
      )
   )
   (D-Initialise)    ;; initialise the system
)

(defun d-maloadcomp (&rest args)
;;
;;   Loads only those files necessary for the compilation of user files
;;   and not those used in the analyser
;;
   (cond
      ((and args (atom (car args)))
	 (load (concat (car args) "/makesp"))
	 (load (concat (car args) "/mkwgram"))
	 (load (concat (car args) "/makelex"))
	 (load (concat (car args) "/mafuncs"))
      )
      ((null args)         ;; no directory given
         (load "makesp")   ;; compile spelling rules
         (load "mkwgram")     ;; compile word grammar
         (load "makelex")   ;; compile dictionary
	 (load "mafuncs")       ;; some of the basic files
      )
      (t
         (error "directory not specified as atom")
      )
   )
   (D-Initialise)    ;; initialise the system
)


(defun d-maloadmap (&rest args)
;;
;;   Loads only those files necessary for the loading of compiled 
;;   user files and the analyser.
;;
   (cond
      ((and args (atom (car args)))
	 (load (concat (car args) "/mafuncs"))
	 (load (concat (car args) "/analyse"))
	 (load (concat (car args) "/autorun"))
	 (load (concat (car args) "/mconcat"))
      )
      ((null args)         ;; no directory given
	 (load "mafuncs")       ;; some of the basic files
         (load "analyse")       ;; morpho-parser
         (load "autorun")       ;; morphographemic-analyser
	 (load "mconcat")       ;; surface form generator
      )
      (t
         (error "directory not specified as atom")
      )
   )
   (D-Initialise)    ;; initialise the system
)


