;;         
;;  Graham Russell    MAY 1986
;;  Amended 27th March 1986 AWB
;;  Re-amended September 1986 GJR
;;
;;  (Graphotactically redundant members removed from character sets:
;;   compare those commented out with ;;;*.  This reduces the size of 
;;   the compiled spelling rule file.)
;;
;;
;;   Copyright Graeme Ritchie, Alan Black,
;;             Steve Pulman and Graham Russell  1987
;;
;;      ---------------------------------------------
;;      |    Not to be used for military purposes   |
;;      ---------------------------------------------
;;

SurfaceAlphabet
	{ a b c d e f g h i j k l m n o p q r s t u v w x y 
          z - " " "'" }
SurfaceSets
;;;*	C is { b c d f g h j k l m n p q r s t v w x z }
	C is { b c d f g h j k l m n p r s t v w z }
;	V is { a e i o u }
	V is { a e i o u y }
	V2 is { e i o u y }		;;  for gemination
	NLR is { n l r }
	S is { s x z }
;;;*	C2 is { b d f h j k l m n p q r s t v w x y z }		;; no C,G 
	C2 is { b d f k l m n p r s t v w z }		
;;;*	NB is { a c d e f g h i j k l m n o p q r s t u v w x y z }
	NB is { l n r t u }
;;;*	NN is { a b c d e f g h i j k m o p q s t u v w x y z }
	NN is { b c f l o r s t v z }    ;; No L,R, too 
	=  is { a b c d e f g h i j k l m n o p q r s t u v 
                w x y z - " " "'" 0 }

LexicalAlphabet
	{ a b c d e f g h i j k l m n o p q r s t u v w x y z - + " " "'" }
LexicalSets
;;;*	C is { b c d f g h j k l m n p q r s t v w x z }
	C is { b c d f g h j k l m n p r s t v w z }
;	V is { a e i o u }
	V is { a e i o u y }
	NLR is { n l r }
	S is { s x z }
;;;*	C2 is { b d f h j k l m n p q r s t v w x y z } ;; no C,G 
	C2 is { b d f k l m n p r s t v w z }		
;;;*	NC is { a b d e f g h i j k l m n o p q s t u v w x y z };; no Rs too.
	NC is { a b d e f g h j k l m n o p s t u v x z }  
;;;*	NI is { a b c d e f g h j k l m n o p q r s t u v w x y z }
	NI is { a d e f h l m n o p s w y }
	= is { a b c d e f g h i j k l m n o p q r s t u v w x y z - + " " "'" }

DefaultPairs
	+:0    ;; the boundary symbol just disappears if nothing else happens
	-:0    ;; hyphens are optional, they need not be in the surface string
	0:" "  ;; multiple spaces will be contracted to a single space
	" ":-  ;; surface strings can contain hyphens instead of spaces


Rules

Epenthesis
 ;*************************************************************************;
 ;   Add "e" at + boundary following sibilants or a surface "i" matching   ;
 ;   a lexical "y": "horses", "churches", "dishes", "boxes", "quizzes",    ;
 ;   "tries", etc.                                                         ;
 ;*************************************************************************;
	+:e  <=>  { < s:s h:h > S:S y:i } --- s:s
	     or   < c:c h:h > --- s:s
             or   < =:C { =:o =:u } > --- s:s

Gemination-1
 ;*************************************************************************;
 ;  Double the final consonant of a word when the suffix begins with a     ;
 ;  vowel: "bigger", "tapped", etc.                                        ;
 ;*************************************************************************;
	+:X  =>  < { < q:q u:u > C:C } V:V =:X > --- { =:V2 =:a } 
		  where X in { b d f g m p s t z }

Gemination-2
 ;*************************************************************************;
 ;  As for Gemination-1, but if the suffix starts with "a", the next       ;
 ;  character can't be "n": "travelled", etc.                              ;
 ;*************************************************************************;
	+:Y  =>  < C:C V:V =:Y > --- =:V2
	     or   < C:C V:V =:Y > --- < =:a =:NN >
		  where Y in { n l r }

Y-to-I
 ;*************************************************************************;
 ;  Lexical "y" corresponds to surface "i": "tried", "presidential",       ;
 ;  "sunnier", "heaviness", "multiplication", etc.                         ;
 ;*************************************************************************;
	y:i  <=>  { C:C c:t } --- < +:= a:a =:NB >
	     or   { +:= C:C < q:q u:u > } --- < +:= NI:= > 
	     or   =:= --- < +:c a:a { t:t l:l } >  ;; c-insertion
		  
Elision
 ;*************************************************************************;
 ;  Lexical "e" corresponds to no surface character in a variety of        ;
 ;  contexts.                                                              ;
 ;*************************************************************************;
        e:0  <=>  C2:C2 --- < +:0 V:= > 	; larg00er
             or   < C:C =:u > --- < +:0 { a:a i:i } >	; continu00ing
	     or   { < C:C V:V > g:g c:c } --- < +:0 { e:e i:i } > ; rac00ed
	     or   l:0 --- +:0			; possib000ly
	     or   c:c --- < +:0 a:0 t:t >	; reduc000tion
	     or   i:y --- +:0			; ty00ing
	     or   =:= --- +:i 			; reptil0ian

I-to-Y
 ;*************************************************************************;
 ;  Lexical "i" corresponds to surface "y" when followed by a deleted "e"  ;
 ;  and a suffix starting with "i": "tying", etc.                          ;
 ;*************************************************************************;
	i:y  <=>  =:= --- < e:0 +:0 i:i >

C-insertion
 ;*************************************************************************;
 ;  The lexical boundary symbol corresponds to surface "c": "application", ;
 ;  "meteorological", etc.                                                 ;
 ;*************************************************************************;
	+:c  <=>  < NC:= y:i >  --- < a:a { t:t l:l } >

K-insertion
 ;*************************************************************************;
 ;  A final "c" is not doubled in Gemination contexts, but followed by     ;
 ;  "k": "trafficker", "panicky", "picnicking", etc.                       ;
 ;*************************************************************************;
	+:k  <=>  < V:V c:c > --- { e:e y:y }			
             or   < V:V c:c > --- < i:i { n:n o:o f:f} >

A-deletion
 ;*************************************************************************;
 ;  Lexical "a" corresponds to no surface character when starting a        ;
 ;  suffix such as "+ation": "reduction", "intervention", etc.             ;
 ;*************************************************************************;
	a:0  <=>  < u:u c:c e:= +:0 > --- t:t
	     or	  < e:e n:n e:0 +:0 > --- t:t

E-to-I
 ;*************************************************************************;
 ;  Lexical "e" corresponds to surface "i" before "ous" and suffixes       ;
 ;  starting with "a" except "+able": "gracious", "preferential", etc.     ;
 ;*************************************************************************;
	e:i  <=>  c:= --- < +:0 { =:a =:o } =:NB > 

I-insertion                                                              
 ;*************************************************************************;
 ;  The lexical boundary symbol corresponds to surface "i" before the      ;
 ;  suffixes "+al" and "+an": "managerial", "electrician", etc.            ;
 ;*************************************************************************;
	+:i  <=>  < { +:0 C:C } V:V NLR:NLR > --- < a:a { n:n l:l } >
             or   < { +:0 C:C } V:V c:c > --- < a:a n:n >	
	     or   < { +:0 C:C } V:V l:l e:0 > --- < a:a { n:n l:l } >

C-to-T
 ;*************************************************************************;
 ;  Lexical "c" corresponds to surface "t": "preferential",                ;
 ;  "presidential", etc.                                                   ;
 ;*************************************************************************;
 	c:t  <=>  n:n --- < =:i +:0 a:a =:NB > 

Y-deletion
 ;*************************************************************************;
 ;  Lexical "y" corresponds to no surface character when followed by a     ;
 ;  suffix starting with "i", unless the suffix is "+ing": "harmonic",     ;
 ;  "strategic", "theorist", etc.                                          ;
 ;*************************************************************************;
;        y:0  <=>  { <q:= u:= > n:= g:= h:= r:= l:= } --- < +:0 i:i =:NN >
        y:0  <=>  { <q:= u:= > C:= } --- < +:0 i:i =:NN >

L-deletion
 ;*************************************************************************;
 ;  Lexical "l" corresponds to no surface character when that would lead   ;
 ;  to double or triple "l"s: "possibly", "fully", etc.                    ;
 ;*************************************************************************;
	l:0  <=>  { < V:V b:b > p:p } --- < e:= +:0 l:l >
	      or  < l:l l:l +:0 > --- =:=

L-to-I
 ;*************************************************************************;
 ;  Surface "i" corresponds to lexical "l" before surface "l"              ;
 ;  corresponding to lexical "e": "possibility", "stabilize", etc.         ;
 ;*************************************************************************; 
;	l:i  <=>  < V:V b:b > --- < e:= +:0 i:i >
	l:i  <=>  < V:V b:b > --- < e:= +:0 i:i { t:t z:z } >

E-to-L
 ;*************************************************************************;
 ;  Surface "l" corresponds to lexical "e": see L-to-I                     ;
 ;*************************************************************************;
;	e:l  <=>  l:i --- < +:0 i:i { t:t z:z } >
	e:l  <=>  l:i --- +:0 
