;;
;;
;;      biglexrules.ru
;;
;;      Graham Russell - March, 1987
;;
;;      Rules to enlarge and multiply lexical entries, and then
;;      check their contents.   The rules given here must be
;;      applied in this order.
;;
;;
;;       Copyright Graeme Ritchie, Alan Black,
;;             Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;


Completion Rules

;	Add (VFORM BSE), (INFL +) and (FIN -) to verb entries - 
;	uninflected stem and bare infinitive forms are generally 
;	identical:
Add_BSE:
   (_ _ ((V +) (N -) ~(INFL _) ~(FIN _) ~(VFORM _) _rest) _ _) =>
      (& & ((V +) (N -) (INFL +) (FIN -) (VFORM BSE) _rest) & &)

;	Add (PRD -) as default to verb entries with (VFORM EN) - 
;	creates entries for past participles:
Add_PRD_MINUS:
   (_ _ ((VFORM EN) ~(PRD _) ~(FIN _) _rest) _ _) =>
      (& & ((VFORM EN) (PRD -) (FIN -) _rest) & &)

;	Add (PRD +) as default to verb present participle entries:
Add_PRD_PLUS:
   (_ _ ((VFORM ING) ~(PRD _) _rest) _ _) =>
      (& & ((VFORM ING) (PRD +) _rest) & &)

;	Add (FIN -) as default to entries with VFORM specifications -
;	these are non-finite:
Add_FIN:
   (_ _ ((VFORM _vf) ~(FIN _) _rest) _ _) =>
      (& & ((VFORM _vf) (FIN -) _rest) & &)

;	Add (BAR -1) as default to entries with FIX specifications -
;	affixes are lower level units than complete words:
Add_BAR_MINUS_ONE:
   (_ _ ((FIX _fix) ~(BAR _) _rest) _ _) =>
      (& & ((FIX _fix) (BAR -1) _rest) & &)

;	Add (LAT +) to entries with V specifications - major 
;	categories are "latinate" by default:
Add_LAT_PLUS:
   (_ _ ((V _v) ~(LAT _) _rest) _ _) =>
      (& & ((V _v) (LAT +) _rest) & &)

;	Add (AT +) to entries with (LAT +) specifications - 
;	"latinate" stems can take the suffixes +ation, +ative, 
;	+ion, +ive.  The latter pair require the specification 
;	(AT -) in their stem, and may therefore not attach to
;	those having the default (AT +):
Add_AT_PLUS:
   (_ _ ((LAT +) ~(AT _) _rest) _ _) =>
      (& & ((AT +) (LAT +) _rest) & &)

;	Add (INFL -) as default to entries with AFORM specifications;
;	prevents inflection of irregular adjectives and those already 
;	inflected:
Add_INFL_MINUS_AFORM:
   (_ _ ((AFORM _af) ~(INFL _) _rest) _ _) =>
      (& & ((INFL -) (AFORM _af) _rest) & &)

;	Add (INFL -) as default to entries with VFORM specifications -
;	past participles, gerunds, etc. cannot be inflected:
Add_INFL_MINUS_VFORM:
   (_ _ ((VFORM _vf) ~(INFL _) _rest) _ _) =>
      (& & ((INFL -) (VFORM _vf) _rest) & &)

;	Add (INFL -) as default to entries with FIN specifications - 
;	finite verbs cannot be further inflected:
Add_INFL_MINUS_FIN:
   (_ _ ((FIN _fin) ~(INFL _) _rest) _ _) =>
      (& & ((INFL -) (FIN _fin) _rest) & &)

;	Add (INFL -) as default to entries with (PLU +) specifications -
;	plural nouns cannot be further inflected:
Add_INFL_MINUS_PLU:
   (_ _ ((PLU +) ~(INFL _) _rest) _ _) =>
      (& & ((INFL -) (PLU +) _rest) & &)

;	Add (INFL -) as default to entries with (PRO +) specifications -
;	pronominals lack regular plural forms:
Add_INFL_MINUS_PRO:
   (_ _ ((PRO +) ~(INFL _) _rest) _ _) =>
      (& & ((PRO +) (INFL -) _rest) & &)

;	Add (INFL -) as default to (QUA +) adjective entries:
Add_INFL_MINUS_QUA:
   (_ _ ((V +) (N +) (QUA +) ~(INFL _) _rest) _ _) =>
      (& & ((V +) (N +) (QUA +) (INFL -) _rest) & &)

;	Add (BAR 0) as default to entries with V and N specifications -
;	anything that is not an affix(specified as (BAR -1)) is a 
;	complete word:
Add_BAR_ZERO:
   (_ _ ((N _n) (V _v) ~(BAR _) _rest) _ _) =>
      (& & ((BAR 0) (N _n) (V _v) _rest) & &)

;	Add (COUNT +) as default to noun entries -
;	typical nouns are countable:
Add_COUNT:
   (_ _ ((N +) (V -) ~(PN +) ~(COUNT _) _rest) _ _) =>
      (& & ((N +) (V -) (COUNT +) _rest) & &)
;	(NB Dubious grammatical status)
;	***************************************************

;	Add (NFORM NORM) as default to noun entries - 
;	only the dummy subjects it and there have different
;	specifications for NFORM:
Add_NFORM:
   (_ _ ((N +) (V -) ~(NFORM _) _rest) _ _) =>
      (& & ((N +) (V -) (NFORM NORM) _rest) & &)
;	(NB Could be avoided by revising the grammar)
;	***************************************************

;	Add (PLU -) as default to noun entries - most
;	nouns are entered in their singular form, as the
;	plural may be obtained by regular suffixation:
Add_PLU_MINUS:
   (_ _ ((V -) (N +) ~(PLU _) _rest) _ _) =>
      (& & ((N +) (V -) (PLU -) _rest) & &)

;	Add (INFL +) as default to entries with (BAR -1) specifications - 
;	typical affixes permit further suffixation (i.e. inflectional 
;	suffixes are a special case, and have already had their entries
;	augmented with (INFL -) by this stage:
Add_INFL_PLUS_BAR_MINUS_ONE:
   (_ _ ((BAR -1) ~(INFL _) _rest) _ _) =>
      (& & ((INFL +) (BAR -1) _rest) & &)

;	Add (INFL +) as default to entries with (BAR 0) specifications -
;	typical words are inflectable, and exceptions are specified as
;	(INFL -) either by hand or by a previous completion rule:
Add_INFL_PLUS_BAR_ZERO:
   (_ _ ((BAR 0) ~(INFL _) _rest) _ _) =>
      (& & ((INFL +) (BAR 0) _rest) & &)

;	Add (QUA -) as default to adjective entries -
;	most adjectives cannot be used as determiners:
Add_QUA:
   (_ _ ((V +) (N +) ~(QUA _) _rest) _ _) =>
      (& & ((V +) (N +) (QUA -) _rest) & &)

;	Add (DEF -) as default to adjective entries with (QUA +) 
;	specifications - most of these determiners are indefinites:
Add_DEF:
   (_ _ ((N +) (V +) (QUA +) ~(DEF _) _rest) _ _) =>
      (& & ((N +) (V +) (DEF -) (QUA +) _rest) & &)

;	Add default AGR specification to entries with (QUA +) -
;	most determiners appear with NPs:
Add_AGR:
   (_ _ ((QUA +) ~(AGR _) _rest) _ _) =>
      (& & ((QUA +) (AGR ((N +) (V -) (BAR 2))) _rest) & &)
 
;	Add (AUX -) as default to verb entries - most verb are 
;	not auxiliaries, and those which are have been explicitly 
;	marked as such.  Only auxiliary verbs can bear the
;	specifications (INV +) or (NEG +), so this rule also adds
;	suitable negative specifications:
Add_AUX_INV_NEG:
   (_ _ ((BAR 0) (V + ) (N -) ~(AUX _) ~(INV _) ~(NEG _) _rest) _ _) =>
      (& & ((BAR 0) (V + ) (N -) (AUX -) (INV -) (NEG -) _rest) & &)

;	Add (NEG -) to auxiliaries:
Add_AUX_NEG_MINUS:
   (_ _ ((V +) (N -) (AUX +) ~(NEG _) _rest) _ _) =>
      (& & ((V +) (N -) (AUX +) (NEG -) _rest) & &)

;	Add (PART +) as default to adjective entries with (QUA +)
;	specifications - determiner adjectives typically appear in
;	partitive "Det of the Ns" constructions:
Add_PART_QUA_PLUS:
   (_ _ ((V +) (N +) (QUA +) ~(PART _) _rest) _ _) =>
      (& & ((V +) (N +) (QUA +) (PART +) _rest) & &)

;	Add (PART -) as default to adjective entries with (QUA -)
;	specifications - non-determiner adjectives do not appear
;	in partitives:
Add_PART_QUA_MINUS:
   (_ _ ((V +) (N +) (QUA -) ~(PART _) _rest) _ _) =>
      (& & ((V +) (N +) (QUA -) (PART -) _rest) & &)

;	Add (SUBCAT NP) as default to (non-(PRO +)) 
;	preposition entries - typically, prepositions 
;	take a NP complement:
Add_SUBCAT_NP_PREP:
   (_ _ ((V -) (N -) ~(PRO +) ~(SUBCAT _) _rest) _ _) =>
       (& & ((V -) (N -) (SUBCAT NP) _rest) & &)

;	Add (SUBCAT NULL) as default to (BAR 0) entries -
;	words are intransitive unless they have been
;	specified otherwise:
Add_SUBCAT_NULL_BAR_ZERO:
   (_ _ ((BAR 0) ~(SUBCAT _) _rest) _ _) =>
      (& & ((BAR 0) (SUBCAT NULL) _rest) & &)

;	Add (PRD -) as default to adjective entries
;	with (QUA +) specifications - determiner adjectives
;	are typically not used predicatively:
Add_PRD_MINUS:
   (_ _ ((V +) (N +) (QUA +) ~(PRD _) _rest) _ _) =>
      (& & ((V +) (N +) (QUA +) (PRD -) _rest) & &)
;	***** NB Claire uses PRD differently; numerals etc. 
;	have to be (PRD +) *****

;	Add (EVER -) as default to entries with (WH +)
;	specifications - (EVER +) appears only in entries
;	for free relative pronouns whatever, etc.:
Add_EVER:
   (_ _ ((WH +) ~(EVER _) _rest) _ _) =>
      (& & ((WH +) (EVER -) _rest) & &)

;	Add (COMPOUND NOT) to major category entries - the
;	word grammar uses this specification to enforce a
;	single structure for compounds of arbitrary length:
Add_COMPOUND_NOT:
   (_ _ ((N _n) (V _v) ~(FIX _) ~(PN +) ~(PRO +) _rest) _ _) =>
      (& & ((N _n) (V _v) (COMPOUND NOT) _rest) & &)

;	Add (PRD -) as default to verb entries - verbs
;	in general are not predicative:
Add_PRD:
   (_ _ ((V +) (N -) ~(PRD _) _rest) _ _) =>
      (& & ((V +) (N -) (PRD -) _rest) & &)

;	Add more to the value of AGR - the dummy subject it
;	behaves like a third person singular pronoun:
Add_More_to_AGR:
   (_ _ ((V +) (N -) (AGR ((N +) (V -) (BAR 2) (NFORM IT) ~(PLU _) ~(PER _))) _rest) _ _) =>
      (& & ((V +) (N -) (AGR ((N +) (V -) (BAR 2) (NFORM IT) (PLU -) (PER 3))) _rest) & &)

;	Add (AGR NPNORM) as default to verb entries -
;	most verbs do not appear with dummy or sentential
;	subjects, but auxiliary verbs must be allowed to have any
;	type of subject:
Add_AGR_NPNORM:
   (_ _ ((V +) (N -) ~(AGR _) ~(AUX +) _rest) _ _) =>
      (& & ((V +) (N -) (AGR ((BAR 2)(V -)(N +)(NFORM NORM))) _rest) & &) 

;	Add (CASE NOM) to AGR value of finite verbs:
Add_AGR_CASE_NOM:
   (_ _ ((V +) (N -) (FIN +) (AGR ((BAR 2)(V -)(N +)(NFORM NORM) ~(CASE _case))) _rest) _ _) =>
      (& & ((V +) (N -) (FIN +) (AGR ((BAR 2)(V -)(N +)(NFORM NORM) (CASE NOM))) _rest) & &)

;	Add (DEF +) as default to determiner entries:
Add_DEF_non_WH:
   (_ _ ((SUBCAT DETN) ~(DEF _) _rest) _ _) =>
      (& & ((SUBCAT DETN) (DEF +) _rest) & &)

;	Add (DEF +) as default to non-WH noun entries - 
;	these are definite:
;   (_ _ ((N +) (V -) ~(WH _) ~(DEF _) _rest) _ _) =>
;      (& & ((N +) (V -) (DEF +) _rest) & &)
;	(WHAT? Nouns aren't definite or indefinite)***************

;	Add (POSS -) as default to determiner entries -
;	determiners are not possessive in general:
Add_POSS_DETN:
   (_ _ ((SUBCAT DETN) ~(POSS _) _rest) _ _) =>
      (& & ((SUBCAT DETN) (POSS -) _rest) & &)

;	Add (PART -) as default to pronoun entries - 
Add_PART_PRO:
   (_ _ ((N +) (V -) (PRO +) ~(PART _) _rest) _ _) =>
      (& & ((N +) (V -) (PRO +) (PART -) _rest) & &)

;	Add (PER 3) as default to noun entries -
;	they must induce third person singular agreement on
;	present tense verbs:
Add_PER_3:
   (_ _ ((N +) (V -) ~(PER _) _rest) _ _) =>
      (& & ((N +) (V -) (PER 3) _rest) & &)

;	Add (ADV -) as default to adjective entries -
;	adverbs derived from adjectives (e.g. quickly) will 
;	have (ADV +):
Add_ADV_ADJ:
   (_ _ ((V +) (N +) ~(ADV _) _rest) _ _) =>
      (& & ((V +) (N +) (ADV -) _rest) & &)

;	Add (NUM -) as default to adjective entries -
;	only numerals are explicitly specified as (NUM +):
Add_NUM_ADJ:
   (_ _ ((V +) (N +) ~(NUM _) _rest) _ _) =>
      (& & ((V +) (N +) (NUM -) _rest) & &)

;	Add (AFORM NONE) as default to adjective entries -
;	
Add_AFORM_NONE:
   (_ _ ((V +) (N +) ~(AFORM _) _rest) _ _) =>
      (& & ((V +) (N +) (AFORM NONE) _rest) & &)

;	Add a suitable AGR entry to cardinals:
Add_AGR_CARD:
   (_ _ ((NUM CARD) ~(AGR _) _rest) _ _) =>
      (& & ((NUM CARD) (AGR ((V -)(N +)(BAR 1)(COUNT +)(PLU +))) _rest) & &)

;	Add a suitable AGR entry to ordinals:
Add_AGR_ORD:
   ~(first _ _ _ _) and
   (_ _ ((NUM ORD) ~(AGR _) _rest) _ _) =>
      (& & ((NUM ORD) (AGR ((V -)(N +)(BAR 1)(COUNT +)(PLU -))) _rest) & &)

;	Add (PN -) as default to noun entries - typical nouns 
;	are not proper names, and those which are have already
;	been specified as such:
Add_PN_MINUS:
   (_ _ ((N +) (V -) ~(PN _) _rest) _ _) =>
      (& & ((N +) (V -) (PN -) _rest) & &)

;	Add (PRO -) as default to noun entries - typical nouns 
;	are not pronouns, and those which are have already been 
;	specified as such:
Add_PRO_MINUS:
   (_ _ ((N +) (V -) ~(PRO _) _rest) _ _) =>
      (& & ((N +) (V -) (PRO -) _rest) & &)

;	Add (POSS -) as default to noun entries - bare nouns
;	aren't possessive, and pronouns that are have already 
;	been marked as such:
Add_POSS_MINUS:
   (_ _ ((N +) (V -) ~(POSS _) _rest) _ _) =>
      (& & ((N +) (V -) (POSS -) _rest) & &)

;	Add (REG +) as default to verb entries - i.e. to entries
;	for verbs that have regular past tense and past participle
;	forms.  Irregular verbs have already been marked as such 
;	in the lexicon:
Add_REG_MINUS:
   (_ _ ((V +) (N -) (INFL +) ~(REG _reg) _rest) _ _) =>
      (& & ((V +) (N -) (INFL +) (REG +) _rest) & &)

;	The following completion rules add specifications required 
;	for the unification parser in version 2.6 ...
;
;	Add (FIX NOT) to non-suffix entries:
Add_FIX_NOT:
   (_ _ ( ~(FIX _fix) _rest) _ _) =>
      (& & ((FIX NOT) _rest) & &)

;	Add (CAT V) to verb categories:
Add_CAT_V:
   (_ _ ((V +) (N -) _rest) _ _) =>
      (& & ((V +) (N -) (CAT V) _rest) & &)

;	Add (CAT N) to noun categories:
Add_CAT_N:
   (_ _ ((V -) (N +) ~(PRO +) _rest) _ _) =>
      (& & ((V -) (N +) (CAT N) _rest) & &)

;	Add (CAT A) to adjective entries:
Add_CAT_A:
   (_ _ ((V +) (N +) _rest) _ _) => 
      (& & ((V +) (N +) (CAT A) _rest) & &) 

;Add (CAT P) to preposition entries:
Add_CAT_P:
   (_ _ ((V -) (N -) _rest) _ _) => 
      (& & ((V -) (N -) (CAT P) _rest) & &) 

;	Add (CAT MINOR) to minor categories:
Add_CAT_MINOR_1:
   (_ _ ( ~(V _v) ~(N _n) (FIX NOT) _rest) _ _) =>
      (& & ((CAT MINOR) (FIX NOT) _rest) & &)

;	Add (CAT MINOR) to pronouns:
Add_CAT_MINOR_2:
   (_ _ ((PRO +) ~(CAT _cat) _rest) _ _) =>
      (& & ((PRO +) (CAT MINOR) _rest) & &)

;	Add (CAT NONE) to prefixes:
Add_CAT_NONE:
   (_ _ ((FIX PRE) ~(CAT _cat) _rest) _ _) =>
      (& & ((FIX PRE) (CAT NONE) _rest) & &)
;****************** for awb *******************

;	Add (VFORM NOT) to verb entries that have no VFORM
;	specification:
Add_VFORM_NOT:
   (_ _ ((V +) (N -) ~(VFORM _vform) _rest) _ _) =>
       (& & ((V +) (N -) (VFORM NOT) _rest) & &)



Multiplication Rules

;	Add an entry with (PRD -) for each one with (VFORM ING)
;	and (PRD +): 
Multi_PRD_MINUS:
   (_ _ ((VFORM ING) (PRD +) _rest) _ _)
   =>>
   (    
      (& & ((VFORM ING) (PRD -) _rest) & &)
   )

;	Passives; add an entry with  (PRD +) for each
;	transitive verb with (PRD -) and (VFORM EN):
Multi_PASSIVES:
   (_ _ ((VFORM EN) (PRD -) _rest) _ _)
   =>>
   (
      (& & ((VFORM EN) (PRD +) _rest) & &)
   )

;	************************************************
;	Add `intransitive' entries for nouns taking
;	complements:
Multi_Intransitives:
   (_ _ ((N +) (V -) (SUBCAT _) _rest) _ _) 
   and ~(_ _ ((SUBCAT NULL) _) _ _)
   and ~(_ _ ((SUBCAT ONE) _) _ _)
   =>>
   (
      (& & ((N +) (V -) (SUBCAT NULL) _rest) & &)
   )
;	****************  NB: Changed  *****************


;	Add entries allowing plural, first person, and second person 
;	agreement for all verbs:
Multi_Person_Agreement1:
   (_ _ ((VFORM BSE) (FIN -) (AGR ((N +)(V -)(BAR 2)(NFORM NORM))) (INFL +) ~(SUBCAT SR1) ~(SUBCAT SR2) ~(AUX +) _rest) _ _)
   =>>
   (
      (& & ((VFORM NOT) (FIN +) (INFL -) (PAST -) (AGR ((N +)(V -)(BAR 2)(CASE NOM)(NFORM NORM)(PLU +))) _rest) & &)
      (& & ((VFORM NOT) (FIN +) (INFL -) (PAST -) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 1)(PLU -))) _rest) & &)
      (& & ((VFORM NOT) (FIN +) (INFL -) (PAST -) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 2)(PLU -))) _rest) & &)
   )

Multi_Person_Agreement2:
   (_ _ ((V +) (N -) ~(VFORM _) ~(AGR _) ~(FIN _) ~(INFL _) (AUX +) _rest) _ _)
   =>>
   (
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (AUX +) (AGR ((N +)(V -)(CASE NOM)(BAR 2)(PLU +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (AUX +) (AGR ((N +)(V -)(BAR 2)(CASE NOM)(PER 1)(PLU -))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (AUX +) (AGR ((N +)(V -)(BAR 2)(CASE NOM)(PER 2)(PLU -))) _rest) & &)
   )

Multi_Person_Agreement3:
   (_ _ ((V +) (N -) (VFORM BSE) (FIN -) (AGR ((N +)(V -)(BAR 2)(NFORM NORM))) (INFL +) (SUBCAT SR2) _rest) _ _)
   =>>
   (
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR2) (AGR ((N +)(V -)(BAR 2)(CASE NOM)(NFORM NORM)(PLU +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR2) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 1)(PLU -))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR2) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 2)(PLU -))) _rest) & &)
      (& & ((V +) (N -) (VFORM BSE) (FIN -) (INFL +) (SUBCAT SR2) (AGR ((V +)(N -)(BAR 2)(SUBJ +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (PAST -) (INFL -) (SUBCAT SR2) (AGR ((V +)(N -)(BAR 2)(SUBJ +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (PAST -) (INFL -) (SUBCAT SR2) (AGR ((V -)(N +)(BAR 2)(CASE NOM)(NFORM IT))) _rest) & &)
      (& & ((V +) (N -) (VFORM BSE) (FIN -) (INFL +) (SUBCAT SR2) (AGR ((V -)(N +)(BAR 2)(CASE NOM)(NFORM IT))) _rest) & &)
   )

Multi_Person_Agreement4:
   (_ _ ((V +) (N -) (VFORM BSE) (FIN -) (AGR ((N +)(V -)(BAR 2)(NFORM NORM))) (INFL +) (SUBCAT SR1) _rest) _ _)
   =>>
   (
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR1) (AGR ((N +)(V -)(BAR 2)(CASE NOM)(NFORM NORM)(PLU +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR1) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 1)(PLU -))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (INFL -) (PAST -) (SUBCAT SR1) (AGR ((N +)(V -)(BAR 2)(NFORM NORM)(CASE NOM)(PER 2)(PLU -))) _rest) & &)
      (& & ((V +) (N -) (VFORM BSE) (FIN -) (INFL +) (SUBCAT SR1) (AGR ((V +)(N -)(SUBJ +)(BAR 2))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (PAST -) (INFL -) (SUBCAT SR1) (AGR ((V +)(N -)(BAR 2)(SUBJ +))) _rest) & &)
      (& & ((V +) (N -) (VFORM NOT) (FIN +) (PAST -) (INFL -) (SUBCAT SR1) (AGR ((V -)(N +)(BAR 2)(CASE NOM)(NFORM IT))) _rest) & &)
      (& & ((V +) (N -) (VFORM BSE) (FIN -) (INFL +) (SUBCAT SR1) (AGR ((V -)(N +)(BAR 2)(CASE NOM)(NFORM IT))) _rest) & &)
   )


Consistency Checks

;; None in this version, but the keyword is necessary. 

