/* mkwidtable.c -- Copyright 1992 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* Rebuild the database that lq-text uses to map words into numbers.
 * This is useful if you think it got corrupt.  It is also useful if you
 * are going to store a database, because you can remove the dbm files that
 * make up the wordlist.  WARNING: this will stop working, may already have
 * stopped working.  It is undocumented because it might not work.
 *
 * $Id: mkwidtable.c,v 1.1 92/02/15 04:10:35 lee Exp $
 */

#include "globals.h"
#include "error.h"

#include <sys/types.h>
#include <unistd.h> /* why is this needed? */
#include <stdio.h>

#include "fileinfo.h"
#include "wordindex.h"
#include "wordinfo.h"
#include "smalldb.h"

extern lqWriteAccess(); /* Allow write access to the database */

int AsciiTrace = 0;
char *progname = "mkwidtable";

long
MakeNewWordMap()
{
    long WordsSeen = 0;
    FILE *IndexFile;
    char Entry[WIDBLOCKSIZE];
    char Word[1024];

    lqWriteAccess();

    if ((IndexFile = fopen(WIDINDEXFILE, "r")) == (FILE *) 0) {
	Error(E_FATAL|E_SYS,
	    "Couldn't open word index file \"%s\"",
	    WIDINDEXFILE
	);
    }

    /* for each word in the index */

    while (fread(Entry, sizeof Entry, 1, IndexFile) > 0) {
	t_WordInfo WordInfo;

	if (!WordsSeen) {
	    WordsSeen++;
	    continue; /* block 0 unused */
	}

	/* make a WordInfo structure */
	WordInfo.Length = (int) Entry[0];
	WordInfo.Word = Word;
	WordInfo.WID = WordsSeen;
	strncpy(Word, &Entry[1], WordInfo.Length); /* [1] coz of length byte */
	Word[WordInfo.Length] = '\0';

	if (AsciiTrace) {
	    printf("%ld %s\n", WordsSeen, Word);
	}

	/* put the word into the index */
	if (PutWordIntoIndex(&WordInfo) < 0) {
	    Error(E_BUG, "failed to put \"%s\" into index\n", Word);
	}

	WordsSeen++;
    }
}

DBM *db;

main(argc, argv)
    int argc;
    char *argv[];
{
    progname = argv[0];
    AsciiTrace = 1;
    (void) MakeNewWordMap();
    enddb(db);
    cleanupdb(); /* empty the db cache */
}

int
PutWordIntoIndex(WordInfo)
    t_WordInfo *WordInfo;
{
    char NumBuf[sizeof(t_WID) + 1];
    char *q = NumBuf;
    datum key, data;

    /** First, write the WID itself, so we can go from Word to WID */

    key.dptr = WordInfo->Word;
    key.dsize = WordInfo->Length;

    sWriteNumber(&q, WordInfo->WID);

    data.dptr = NumBuf;
    data.dsize = q - NumBuf;

    /* contact database server */
    if ((db = startdb(WordIndex)) == (DBM *) 0) {
	Error(E_FATAL|E_SYS, "Couldn't create new index \"%s\"", WordIndex);
    }

    return dbm_store(db, key, data, DBM_REPLACE);
}
