/* strings.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: strings.c,v 1.1 92/02/15 04:01:09 lee Exp $ */

/* Strcontains(s1, s2) - true if s2 contains an instance of s1;
 * This routine would be better named "StringContainedIn" because of
 * the order of its arguments, which was chosen to match strchr()/index().
 */


# if 0

/* A little helper function... but not needed because it's included
 * inline in Strcontains().  It's here in case I ever want it again!
 */

static INLINE int
strprefix(Prefix, String)
    register char *Prefix;
    register char *String;
{
    while (*String++ == *Prefix++) {
	if (!*Prefix) return 1;
    }
    return 0;
}

#endif

int
strcontains(ShortString, LongString)
    char *ShortString;
    char *LongString;
{
    register char *p;

    /* This is basically a simple "grep" algorithm.
     * Adding Boyer-Moore style delta tables would speed it up, but
     * it isn't used all that often in lq-text - at most a dozen or so
     * times per input file.  I've gone as far as putting strprefix() inline,
     * to save a few function calls, but that's all.
     */

    for (p = LongString; *p; p++) {
	if (*p == *ShortString) {
	    /** if strprefix(ShortString, p)) return 1; **/

	    /* inline expansion of strprefix() */
	    register char *String = p, *Prefix = ShortString;

	    while (*String++ == *Prefix++) {
		if (!*Prefix) {
		    return 1;
		}
	    }

	    /* another optimisation: if there's not enough string left,
	     * we can return false; this happens if we have reached the
	     * end of String (so that *String == '\0') and the remaining
	     * length of p (String - p) is less than the length of the
	     * prefix.  But if !*String, and we get here, we have reached
	     * the end of p and not the end of the prefix, so we have already
	     * gone too far.
	     */
	    if (!*String) {
		return 0;
	    }
	}
    }
    return 0;
}
