/* IsDir.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: isdir.c,v 1.1 92/02/15 03:37:05 lee Exp $ */

#include <sys/types.h>
#include <sys/stat.h>

int
IsDir(Dir)
    char *Dir;
{
    struct stat statbuf;

    /* If the Directory is the null string, it isn't a directory.
     * We could return -1 in this case, but there's no need.
     *
     * If the name has zero characters, on Unix it's the current directory,
     * but that's probably not what was intended - you can use . for the
     * current directory.
     */
    if (!Dir || !*Dir) return 0;

    /* If the stat failed, chances are it doesn't exist.
     *
     * Another implementation is to look for "Directory/.", but that won't
     * work over NFS, and may generate error messages on the system console
     * with some versions of NFS!
     */
    if (stat(Dir, &statbuf) < 0) return 0;

    if ((statbuf.st_mode & S_IFMT) != S_IFDIR) {
	/* We could also check to see if it's a symbolic link that points
	 * at a directory, but that is unlikely, as stat(2) is supposed to
	 * return information about the target of the link, not about the
	 * file containing the link - see lstat(2).
	 * The only time it might say it's a symlink is if it points to a
	 * directory that isn't there, in which case we should return 0
	 * anyway!
	 */

	return 0;
    }

    return 1;
}
