/* GetLine.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: getline.c,v 1.2 92/02/01 22:57:48 lee Exp $ */

#include <stdio.h>
#include <ctype.h>

#include "globals.h"
#include "emalloc.h"

extern int AsciiTrace;

static int LineInFile = 0;
static FILE *LastFile = 0;

int
lqLineInFile()
{
    return LineInFile;
}

char *
GetLine(fp, Name)
    FILE *fp;
    char *Name;
{
    static char *Line = (char *) 0;
    static int Length = 0;
    int ch;
    register char *p;

    if (!Line) {
	if (Length <= 10) Length = 30;
	Line = emalloc(Length);
    }

    p = Line;

    if (fp == LastFile) {
	++LineInFile;
    } else {
	LineInFile = 0; /* number lines from zero! */
	LastFile = fp;
    }

    while ((ch = getc(fp)) != EOF) {
	static int HaveWarned = 0;

	if (isspace(ch)) {
	    if (p == Line) { /* ignore blank lines and leading blanks */
		continue;
	    }
	    if (ch == '\n') {
		if (p == (char *) 0) {
		    /* how could this ever happen?  do I need it? */
		    p = Line;
		    continue;
		}
		*p = '\0';
		return Line;
	    }
	    if (AsciiTrace && !HaveWarned) {
		fprintf(stderr,
"%s: -f: Warning: spaces found in filenames read from \"%s\"\n",
							    progname, Name);
		HaveWarned = 1;
	    }
	}

	/* add the character to the string */
	if (p - Line + 1 >= Length) {
	    int SaveWhere = p - Line;
	    Length += 30;
	    Line = erealloc(Line, Length);
	    p = &Line[SaveWhere];
	}
	*p++ = ch;
    }

    if (p && Line && p != Line) {
	fprintf(stderr, "%s: -f: warning: no newline at the end of \"%s\"\n",
						progname, Name);
	*p = '\0';
	return Line;
    }

    return (char *) 0;
}

