/* Common.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * $Id: Common.c,v 1.4 92/04/18 19:35:10 lee Exp $
 *
 * Handle Common Word file
 *
 * $Log:	Common.c,v $
 * Revision 1.4  92/04/18  19:35:10  lee
 * Included <ctype.h>
 * 
 * Revision 1.3  92/04/18  19:34:41  lee
 * changed some buffer lengths...
 * 
 * Revision 1.2  92/02/09  19:58:25  lee
 * Use Error(); also now have two common lists instead of one, for slightly
 * more speed.  Can't have one for each letter of the alphabet, don't have a
 * portable way of finding the alphabet size!  it isn't 26 in Sweden, for
 * example...
 * 
 * Revision 1.1  92/02/09  19:35:49  lee
 * Initial revision
 * 
 */

#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include "globals.h" /* defines and declarations for database filenames */
#include "error.h"
#include "fileinfo.h"
#include "wordinfo.h"
#include "wordrules.h"
#include "emalloc.h"

/** Unix system calls that need to be declared: **/
    /* (none) */
/** C Library functions that nees to be declared: **/

/** lqtext functions that need to be declared: **/
extern char *WordRoot(/* t_WordInfo Root*/);

/** Functions from this file that need to be declared: **/

void InsertCommonWord();

/** **/

#define STRCMP(s1,s2) ((*(s1) == *(s2)) ? strcmp(s1, s2) : *(s1) - *(s2))
	/* faster then strcmp in the (common) case where the
	 * strings differ at the first character.
	 * From an idea by Henry Spencer (utzoo!henry)
	 */

/** **/

extern int AsciiTrace;

typedef struct s_WordList {
    char *Word;
    struct s_WordList *Next;
} t_WordList;

static t_WordList *CommonWordsLow = 0;
static t_WordList *CommonWordsHigh = 0;

int
TooCommon(WordInfo)
    t_WordInfo *WordInfo;
{
    register char *Word = WordInfo->Word;
    register t_WordList **WP;

    WP = (WordInfo->Word[0] < 'm') ? &CommonWordsLow : &CommonWordsHigh;

    for (; *WP; WP = &(*WP)->Next) {
	int i = STRCMP((*WP)->Word, Word);

	if (i == 0) return 1; /* yes, it's common */
	else if (i > 0) return 0;
    }
    return 0;
}

static char *FileName = "Internal Error";
/* should be set before being printed! */

int
ReadCommonWords(CommonFile)
    char *CommonFile;
{
    extern char *fgets();
    extern int AsciiTrace;
    static void InsertqxxWords();

    FILE *fd;
    char Buffer[200];
    t_WordInfo W;
    char *Root;
    t_WordList *WP;

    if ((fd = fopen(CommonFile, "r")) == (FILE *) 0) {
	Error(E_FATAL, "Can't open common word list fie \"%s\"", CommonFile);
    }

    FileName = CommonFile;

    while (fgets(Buffer, sizeof(Buffer), fd) != (char *) 0) {
	register char *p;
	char *Start;

	for (p = Buffer; *p; p++) {
	    if (*p == '#') break;
	    if (StartsWord(*p)) break;
	}

	if (*p == '#' || !*p) {
	    continue;
	}

	Start = p;

	for (; *p; p++) {
	    if (!WithinWord(*p)) break;
	    if (*p == '\'' && !WithinWord(p[1])) break;
	}

	if (p - Start + 1 < MinWordLength) continue;

	*p = '\0'; /* delete trailing \n or whatever */
	W.Word = Start;
	W.Length = p - Start; /* length excludes the \0 */

	Root = WordRoot(&W);
	InsertCommonWord(Root);
    }
    (void) fclose(fd);

    if (AsciiTrace > 1) {
	for (WP = CommonWordsLow; WP; WP = WP->Next) {
	    fprintf(stderr, "%s: Ignore \"%s\"\n", CommonFile, WP->Word);
	}
	for (WP = CommonWordsHigh; WP; WP = WP->Next) {
	    fprintf(stderr, "%s: Ignore \"%s\"\n", CommonFile, WP->Word);
	}
    }

    /* insert words of the form qxx* automatically */
    InsertqxxWords();

    FileName = "Internal Error";
    return 0;
}

static void
InsertqxxWords()
{
    char Buffer[MaxWordLength + 1]; /* +1 for \0 at the end */

    register char *p;

    Buffer[0] = 'q';
    for (p = &Buffer[1]; p - Buffer < MaxWordLength; p++) {
	*p = 'x';
	p[1] = '\0';
	InsertCommonWord(Buffer);
    }
}

void
InsertCommonWord(Root)
    char *Root;
{
    register t_WordList **WP;
    t_WordList *W;

    WP = (Root[0] < 'm') ? &CommonWordsLow : &CommonWordsHigh;
    for (; *WP; WP = &(*WP)->Next) {
	int i = STRCMP((*WP)->Word, Root);

	if (i == 0) return;
	else if (i > 0) break;
    }
    /* insert it before this one! */
    W = (*WP);
    (*WP) = (t_WordList *) emalloc(sizeof(t_WordList));
    (*WP)->Word = emalloc(strlen(Root) + 1);
    (void) strcpy((*WP)->Word, Root);
    (*WP)->Next = W;
    return;
}
