/* numbers.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* ReadNumber and WriteNumber take/return a long, using a compression
 * algorithm to reduce the amount of data taken.
 *
 * They use (char *) pointers instead if prefixes with an s.
 *
 * $Id: numbers.h,v 1.5 92/08/02 09:22:22 lee Exp $
 *
 */

#ifdef HAVE_INLINE

#define PutC(ch, S)  (*((*S)++) = (char) (ch))

INLINE void
sWriteNumber(s, Number)
    char **s;
    unsigned long Number;
{
    while (Number > 0177) {
	PutC((Number & 0177) | 0200, s);
	Number >>= 7;
    }
    PutC(Number & 0177, s);
}


#define GetC(S) \
    ( (unsigned int) * (unsigned char *) ((* (unsigned char **)S)++) )

INLINE unsigned long
sReadNumber(s)
    char **s;
{
    unsigned long Result = 0L;
    int ThereIsMore;
    int Shift = 0;

    do {
	Result |= ((ThereIsMore = GetC(s)) & 0177) << Shift;
	ThereIsMore &= 0200;
	Shift += 7;
    } while (ThereIsMore);
    return Result;
}

#else /* HAVE_INLINE */

extern unsigned long fReadNumber();
extern unsigned long sReadNumber();

extern void fWriteNumber();
extern void sWriteNumber();

#endif /* HAVE_INLINE */

