/* filter.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* filter.h -- define filter table for NX-Text, Liam Quin's text retrieval
 * program.
 * This table is built from a file like a simplified /etc/magic, normally
 * stored in /usr/local/lib/nx-text/lib/filtertable
 * but you can set this either here or in the Makefile.
 *
 * NEEDS: stdio.h
 *
 * $Id: filter.h,v 1.8 92/08/24 00:25:29 lee Exp $
 *
 */

#define FTYPE_NEWS  1
#define FTYPE_MAIL  2
#define FTYPE_CDMS  3
#define FTYPE_MOSTLYASCII 4
#define FTYPE_DEFAULT 5
#define FTYPE_C_SOURCE 6

/* The Type field in each array entry is so that I can do some very simple
 * checking...
 */
extern int fclose(), pclose();
struct s_FilterTable {
    int Type;
    int (* close)(); /* how to close the darned stream */
    char *String;
};
#ifndef FILTERDEF
extern struct s_FilterTable FilterTable[];
#else
struct s_FilterTable FilterTable[] = {
    { 0, fclose, 0 }, /* use fopen() */
#ifndef NEWSFILTER
# define NEWSFILTER "NewsFilter"
#endif
    { FTYPE_NEWS, pclose, NEWSFILTER },
#ifndef MAILFILTER
# define MAILFILTER "MailFilter"
#endif
    { FTYPE_MAIL, pclose, MAILFILTER },
#ifdef FTYPE_CDMS /* CrystalWriter from Syntactics... */
    { FTYPE_CDMS, pclose, "CDMSFilter" },
#endif
#ifdef FTYPE_NTROFF
    { FTYPE_NTROFF, pclose, "lqderoff" }, /* not yet released, sorry */
#endif
    { FTYPE_MOSTLYASCII, pclose, "AsciiFilter" },
#ifdef FTYPE_DEFAULT
    { FTYPE_DEFAULT, pclose, DEFAULTFILTER },
#endif
#ifdef FTYPE_C_SOURCE
    { FTYPE_C_SOURCE, pclose, "CFilter" }, /* leave me last! */
#endif
    /* If you add more, you MUST update MaxFilterType */
    { 0, 0, 0 }
};
#endif
#define MaxFilterType FTYPE_C_SOURCE
