/* declare.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/*
 * $Id: declare.h,v 1.1 92/02/15 05:32:36 lee Exp $
 */

/* This file is included by the global configuration file, globals.h,
 * and contains "extern" definitions for a number of system functions and
 * procedures.
 */

/** stdio functions generally not declared in stdio.h: **/
extern int fprintf();
extern int printf();
extern int fputc();

#ifdef SYSV
extern int sprintf();
#endif

#ifdef BSD
extern char *sprintf();
#endif

extern fclose();
/** system functions **/

/* Some of these are in stdlib.h, but that's not there on enough systems yet
 * to be sensible to use, I fear (Jan 1992).
 * It doesn't always (e.g. on SunOS) define many of them anyway.
 */

extern int exit();
extern void _exit();
extern void perror();

extern int fread();
extern int fwrite();

#define exit(value) \
    { \
	int i = value; \
	int j; \
	exit(i); \
	fprintf(stderr, "%s: exit(%d) failed! Trying _exit\n", \
	    progname, i); \
	/* try to close files first: */ \
	for (j = 3; j < 20; j++) (void) close(j); \
	_exit(i); \
    }

/** **/
