/* TroffFilter.c -- Copyright 1990 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: TroffFilter.c,v 1.1 92/02/15 05:58:25 lee Exp $
 */

/* Filter for troff files (man pages in particular)
 *
 * See FilterMain and wordrules.h for more info.
 *
 */

#ifdef SYSV
 extern int _filbuf(), _flsbuf(); /* for lint! */
#endif
#include <stdio.h>
#include <malloc.h>
#include <ctype.h>
#include "wordrules.h"

#include "emalloc.h"

#define STREQ(boy, girl) ((*(boy) == *(girl)) && !strcmp(boy, girl))

/** C Library functions that need to be declared: **/
/** Functions in this file that need to be declared **/
int GetChar();
/** **/

extern char *progname;
void Filter();

/* Ignore the first word of each line beginning with . or '
 *
 * delete \Xc, \X(cc, \X[cccccc], for X in {f,n,s,*} or absent.
 *
 */

static int AtStartOfLine = 1;

void
Filter(InputFile, Name)
    FILE *InputFile;
    char *Name;
{
    int ch;

    while ((ch = GetChar(InputFile)) != EOF) {
	if (AtStartOfLine) {
	    if (ch == '.' || ch =='\'') {
		putchar(' ');
		CommandLine(InputFile, Name);
	    } else if (ch == '\n') {
		AtStartOfLine = 1;
		putchar('\n');
	    } else {
		AtStartOfLine = 0;
		if (ch == '\\') {
		    if (Process(InputFile, Name, ch) == EOF) return;
		} else {
		    putchar(ch);
		}
	    }
	} else {
	    /* not at start of line */
	    if (ch == '\\') {
		if (Process(InputFile, Name, ch) == EOF) return;
	    } else if (ch == '\n') {
		AtStartOfLine = 1;
		putchar('\n');
	    } else {
		putchar(ch);
	    }
	}
    }
}

Process(InputFile, Name)
    FILE *InputFile;
    char *Name;
{
    int ch = GetChar(InputFile);

    if (ch == EOF) return EOF;

    if (ch == '\n') {
	putchar (ch);
	return 0;
    }

    /* Ignore \fC, \f(XX */
    switch (ch) {
    default:
	putchar(' ');
	return 0;
    case 'f':
    case '*':
    case 'n':
    case 'k':
    case 's':
	if ((ch = GetChar(InputFile)) == EOF || ch == '\n') {
	    if (ch == '\n') putchar(ch);
	    return ch;
	}
	/* fall through */
    case '[':
    case '(':
	/* deal with a troff name */
	if (ch == '(') {
	    /* ignore a 2 character name: */
	    if ((ch = GetChar(InputFile)) == EOF || ch == '\n') {
		if (ch == '\n') putchar(ch);
		else putchar(' ');
		return ch;
	    }
	    if ((ch = GetChar(InputFile)) == EOF || ch == '\n') {
		if (ch == '\n') putchar(ch);
		return ch;
	    }
	} else if (ch == '[') {
	    while ((ch = GetChar(InputFile)) != EOF) {
		if (ch == '\n') putchar(ch);
		else putchar(' ');
		if (ch == ']' || ch == '\n') {
		    return 0;
		}
	    }
	    return EOF;
	} else if (ch == '\'' || ch == '"' || ch == '@') {
	    goto GotDelim;
	}
	putchar(' ');
	return 0; /* single character name, e.g. \fR */

    /* things with a delimiter */
    case 'B': /* bitmap */
    case 'C': /* special character with long name (DWB 3) */
    case 'D': /* ditroff drawing */
    case 'h': /* horizontal motion */
    case 'L': /* v. line */
    case 'l': /* h. line */
    case 'N': /* character number */
    case 'o': /* overstrike - BUG: should join up, not use space */
    case 'q': case 'Q': /* sqrc query (sqtroff) */
    case 'v': /* vmot */
    case 'w': /* width */
    case 'x': /* extra space */
	if ((ch = GetChar(InputFile)) == EOF || ch == '\n') {
	    if (ch == '\n') putchar(ch);
	    else putchar(' ');
	    return ch;
	}
GotDelim:
	{
	    int EndChar = ch;

	    while ((ch = GetChar(InputFile)) != EOF) {
		if (ch == '\n') putchar(ch);
		else putchar(' ');
		if (ch == ch2 || ch == '\n') {
		    return 0;
		}
	    }
	    return EOF;
	}
    }
}

int
GetChar(fd)
    FILE *fd;
{
    static int LastChar = 0;

    if (LastChar) {
	int ch = LastChar;
	LastChar = 0;
	return ch;
    }

    /* Only return a single quote if it is surrounded by letters */
    if ((LastChar = getc(fd)) == '\'') {
	LastChar = getc(fd);
	if (InWord && isalpha(LastChar)) return '\'';
	else return ' ';
    } else {
	int ch = LastChar;
	LastChar = 0;
	return ch;
    }
}

/*
 * $Log:	TroffFilter.c,v $
 * Revision 1.1  92/02/15  05:58:25  lee
 * Initial revision
 * 
 *
 */
