/* Use menu interface to create an rpg character...
 * Liam R. Quin, July 1989
 * 
 * $Header: /usr/src/cmd/lq-text/src/menu/RCS/character.c,v 1.2 90/10/13 03:06:30 lee Rel1-10 $
 *
 * $Log:	character.c,v $
 * Revision 1.2  90/10/13  03:06:30  lee
 * After Sabre.
 * 
 * Revision 1.1  90/08/29  21:49:27  lee
 * Initial revision
 * 
 *
 */

#include <malloc.h>
#ifdef ultrix
# include <cursesX.h>
#else
# include <curses.h>
#endif

#include "menu.h"
#include "error.h"

/* This is needed because of a bug in an old version of "m": */
int MenuUsed = 0; /* (sigh) */

/* Some handy macros */
#ifndef new
# define new(type) (type *) malloc(sizeof(type))
#endif

#ifndef STREQ /* STREQ is an optimisation due to Henry Spencer, utzoo!henry */
# define STREQ(boy,girl) (((*(boy))==(*(girl)))&&!strcmp((boy),(girl)))
#endif

char *cmdname;
char *progname;

extern char *getenv();
extern char *malloc();
extern char *strrchr();

main(argc, argv)
    int argc; char *argv[];
{
    int optchar; /** start getopts stuff **/
    int errflag = 0;
    extern char *optarg;
    extern int optind; /** end getopts stuff **/

    t_MenuBar *MenuBar;
    t_MenuBar *SetUpMenus();
    void SetUpScreen();

    /* Make progname point to the last component of argv[0] */
    progname = strrchr(argv[0], '/');
    if (progname) {
	if (*++progname == '\0') {
	    --progname; /* No Unix filename can do this! */
	}
    } else {
	progname = argv[0];
    }
    /* cmdname lets you say CMDNAME=`basename $0` in a shell script
     * for better error reporting
     */
    cmdname = getenv("CMDNAME");

    while ((optchar = getopt(argc, argv, "XV") != EOF)) {
	switch (optchar) {
	case 'X':
	    Usage(0);
	    /*NOTREACHED*/
	    break;
	case 'V':
	    error(ERR_FATAL, "Version: $Header: /usr/src/cmd/lq-text/src/menu/RCS/character.c,v 1.2 90/10/13 03:06:30 lee Rel1-10 $");
	    /*NOTREACHED*/
	    exit(1);
	case '?':
	    errflag++;
	}
    }
    if (errflag) {
	Usage(1);
    }

    StartCurses();

    MenuBar = SetUpMenus();

    SetUpScreen();

    while (UseMenuBar(MenuBar) != -2) {
	/*NULLBODY*/
	;
    }

    EndCurses();

    exit(0);

    /*NOTREACHED*/
}

Usage(exitstatus)
    int exitstatus;
{
    if (cmdname) fprintf(stderr, "%s: ", cmdname);
    fprintf(stderr, "%s: usage: %s [-XV]\n", progname, progname);
    fprintf(stderr, "\t-X\t-- print this eXplanation\n");
    fprintf(stderr, "\t-V\t-- print %s version info\n", progname);
    exit(exitstatus);
}

int
EndProg()
{
    endwin();
    exit();
}

t_MenuBar *
SetUpMenus()
{
    t_MenuBar *MenuBar = new(t_MenuBar);
    t_Menu *Menu;
    t_MenuItem *MenuItem;
    extern exit();

    if (MenuBar == (t_MenuBar *) 0) {
	error(ERR_FATAL|ERR_MEMORY, "Not enough memory for menu bar");
    }
    MenuBar->MenuBarId = 0; /* Private (oh for c++) */
    MenuBar->HowManyMenus = 0;
    MenuBar->SelectedMenu = 0;
    MenuBar->ScrollPos = 0;
    MenuBar->MenuID = 1;

    if ((Menu = new(t_Menu)) == (t_Menu *) 0) {
	error(ERR_FATAL|ERR_MEMORY, "Not enough memory for menus");
    }

    Menu->Name = "File";

    Menu->Items = (t_MenuItem *) malloc(sizeof(t_MenuItem) * 2);
    Menu->Items[0].Name = "Finish";
    Menu->Items[0].NameLength = 0;
    Menu->Items[0].Function = EndProg;
    Menu->Items[0].Description = "Finish -- leave the program";
    Menu->HowManyItems = 1;


    MenuBar->Menus[0] = Menu;
    MenuBar->HowManyMenus++;

    return MenuBar;
}

typedef struct s_Screen {
    char *Name;  /* "Main Person Screen" */
    char *PcName;
    int PcAge;
    char *PcRace;
    char *PcSex; /* might be more than 2 choices! */
    char *PcAgeGroup; /* Young/elderly/...*/
    char *PcHeightGroup;
    int PcHeight;
    char *PcHairLength;
    char *PcHairColour;
} t_Screen;

t_Screen MainScreen;

void
SetUpScreen()
{
    /* Put some important info on the screen itself...
     * One could use menus to change the screen display, perhaps.
     * A more general program would use a screen form to do this.
     */
    mvwprintw(stdscr, 0, 0, "%s revision %s", progname, "$Revision: 1.2 $");
    mvwaddstr(stdscr, 1, 0, "[press return to continue]");
    refresh();
    (void) getch();
    clear();
    refresh();

    MainScreen.Name = "Main Person Screen";
    MainScreen.PcName = "person.name";
    MainScreen.PcAge = 0;
    MainScreen.PcRace = "null being";
    MainScreen.PcSex = "of indeterminate sex";
    MainScreen.PcAgeGroup = "ageless"; /* Young/elderly/...*/
    MainScreen.PcHeightGroup = "very short";
    MainScreen.PcHeight = 27; /* in inches */
    MainScreen.PcHairLength = "long"; /* in inches */
    MainScreen.PcHairColour = "straight fair"; /* in inches */

    DrawMainScreen();
}

/***

File Edit Person Stats Race Profession Skills Things
-------------------------------------------------------------------------------
Martin the Wood Elf, born 403 years ago (young male)
tall (6'2"), long fair hair

**/

DrawMainScreen()
{
    wclear(stdscr);
    mvwprintw(stdscr, 2, 0, "%s the %s, born %d years ago (%s %s)",
	MainScreen.PcName, MainScreen.PcRace, MainScreen.PcAge,
	MainScreen.PcAgeGroup, MainScreen.PcSex);
    mvwprintw(stdscr, 3, 0, "%s (%d' %d\"), %s %s hair",
	MainScreen.PcHeightGroup,
	MainScreen.PcHeight / 12, MainScreen.PcHeight % 12,
	MainScreen.PcHairLength, MainScreen.PcHairColour);
    
    mvprintw(stdscr, LINES - 1, 0, "**** %s ****", MainScreen.Name);
}

StartCurses()
{
    if (InCurses) {
	error(ERR_FATAL|ERR_INTERNAL, "StartCurses() called in curses mode");
    }
    (void) initscr();
    InCurses = 1;
    (void) cbreak();
    (void) noecho();
    (void) nonl();
    (void) keypad(stdscr, TRUE);
}

EndCurses()
{
    clear();
    (void) refresh();

    InCurses = 0;
    (void) endwin();
}
