/* smalldb.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: smalldb.h,v 1.3 91/03/03 00:12:56 lee Exp $
 */

/* You must include fcntl.h before this file. */

#ifdef ndbm
# include <ndbm.h>
# define FoundDbmOK
# define NDBM
#endif

#ifdef sdbm
# include "sdbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible */
#endif

#ifdef ozmahash
# include "ozmadbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible as well... */
#endif

#ifndef FoundDbmOK
# include "Liamdbm.h"
#endif

#ifndef O_RDWR
# include <fcntl.h>
#endif

#define CACHE 2 /* size of DBM cache in startdb() -- I only use two! */
/* If you rip out the dbm cache stuff for use elsewhere, increse the 2
 * to something like 5 or so!!!  Each entry uses two file pointers.
 * Lee
 */

#ifndef CACHE
# define startdb(FilePrefix) dbm_open(FilePrefix, O_RDWR|O_CREAT, 0640)
# define enddb(db) { if (db) dbm_close(db); }
#endif


#ifndef startdb
DBM *startdb();
#endif

#ifndef enddb
# ifdef CACHE
#  define enddb(db) /* nothing to do, because of the cache */
# else
   void enddb();
# endif /* CACHE */
#endif /* !enddb */

/*
 * $Log:	smalldb.h,v $
 * Revision 1.3  91/03/03  00:12:56  lee
 * Integrated ozmahash.
 * 
 * Revision 1.2  90/10/06  02:18:36  lee
 * Prepared for first beta release.
 * 
 * Revision 1.1  90/08/09  19:16:00  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:47:19  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:16:01  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 * Revision 1.2  89/09/16  21:15:45  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:06:12  lee
 * Initial revision
 * 
 */
