/* pblock.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

#ifndef PBLOCK_H /* the matching endif is at the end of the file... */

# define PBLOCK_H
/* The physical Word Database...
 *
 * First, there is the WID (from 1 to 4 bytes)
 *
 * Then, there is a NEXT pointer (or 0).
 *
 * Then, there is a list of (FID, OFFSET) pairs.
 *
 * $Header: /usr/src/cmd/lq-text/src/h/RCS/pblock.h,v 1.2 90/08/09 19:15:45 lee Rel1-10 $
 *
 * $Log:	pblock.h,v $
 * Revision 1.2  90/08/09  19:15:45  lee
 * after BSD lint and saber-C
 * 
 * Revision 1.1  90/03/01  23:54:37  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:47:04  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:15:36  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 * Revision 1.2  89/09/16  21:15:43  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:06:09  lee
 * Initial revision
 * 
 *
 */

typedef struct {
    t_FID FID;
    unsigned long BlockInFile;
    unsigned short WordInBlock;
    unsigned short Flags;
    unsigned char StuffBefore; /* preceding ignored garbage */
} t_WordPlace;

/* This structure is really only used by addfile; elsewhere arrays of
 * WordlPlace are used.
 */

typedef struct s_WordPlaceList {
    char *Word;
    t_WordPlace WordPlace;
    struct s_WordPlaceList *Next;
} t_WordPlaceList;

/* Warning: One cannot use structure copy for a pblock! */

/* This does *NOT* correspond to the physical disk layout -- see pblock.c */
typedef struct {
    t_WID WID; /* for checking; */
    unsigned long ChainStart;
    unsigned long NumberOfWordPlaces;
    t_WordPlace WordPlaces[1]; /* made by joining lots of disk blocks... */
} t_pblock;

#endif
