# include <stdio.h>			/* lno.c (rev3.7) */

long lno = 1;
int dbles = 0;		/* toggle option for double line numbering */
int strph = 0;		/* toggle and count for strophe numbering */

main(argc, argv)	/* line number text, allowing setting */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	long atol();
	int i;

	if (argc == 1)
	{
		puts("Usage: lno [+n -d -h -sn -] filename(s)\t\t(rev3.7)");
		puts("+n : the beginning line number is n, not 1");
		puts("-d : double line number text with long lines");
		puts("-h : hemistich number text with split lines");
		puts("-sn: number and letter strophes of n lines");
		puts("-  : read standard input instead of files");
		exit(1);
	}
	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '+')
			lno = atol(argv[i]+1);
		else if (*argv[i] == '-')
			getflag(argv[i]);
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			if (dbles)
				dblno(fp);
			if (strph)
				strfno(fp);
			else  /* default action */
				lineno(fp);
			fclose(fp);
		}
		else  /* attempt to open file failed */
		{
			fprintf(stderr,
			"Lno cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	exit(0);
}

getflag(f)		/* parses command line to set options */
char *f;
{
	f++;
	switch(*f)
	{
		case 'd':
			dbles = 1;
			break;
		case 'h':
			strph = 2;
			break;
		case 's':
			strph = atoi(++f);
			if (strph > 26)
			{
				fprintf(stderr,
				"Too many lines per strophe\n");
				exit(1);
			}
			break;
		case NULL:
			if (dbles)
				dblno(stdin);
			if (strph)
				strfno(stdin);
			else
				lineno(stdin);
			break;
		default:
			fprintf(stderr, "Invalid lno flag: -%s\n", f);
			exit(1);
			break;
	}
}

lineno(fp)		/* this function is self-explanatory */
FILE *fp;
{
	char s[BUFSIZ];

	while (fgets(s, BUFSIZ, fp))
	{
		printf("%6ld\t", lno);
		fputs(s, stdout);
		lno++;
	}
}

dblno(fp)		/* number text, incrementing by twos */
FILE *fp;
{
	char s[BUFSIZ];

	while (fgets(s, BUFSIZ, fp))
	{
		printf("%6ld\t", lno);
		fputs(s, stdout);
		lno += 2;
	}
}

strfno(fp)		/* number n line strophes, appending letters */
FILE *fp;
{
	char s[BUFSIZ], ch = 'a';
	int i = 0;

	while (fgets(s, BUFSIZ, fp))
	{
		printf("%5ld%c\t", lno, ch);
		fputs(s, stdout);
		if (++i < strph)
			ch++;
		else
		{
			lno++;
			i = 0;
			ch = 'a';
		}
	}
}
