# include <stdio.h>			/* accent.c (rev3.7) */

char mode = 'a';		/* accent mode: a=file c=cedilla u=umlaut */
char accfile[15] = "accfile";	/* file containing accent mark definitions */

usage()			/* print proper usage and exit */
{
	fprintf(stderr, "Usage: accent [-a accfile] [filename(s)]\t(rev3.7)\n");
	fprintf(stderr, "\taccent mark definitions read from accfile\n");
	exit(1);
}

main(argc, argv)	/* user-controlled module for accent marks */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int n, i;

	n = strlen(argv[0]);
	/* umlaut */
	if (argv[0][n-2] == 'u' && argv[0][n-1] == 't')
		mode = 'u';
	/* cedilla */
	if (argv[0][n-2] == 'l' && argv[0][n-1] == 'a')
		mode = 'c';
	i = 1;
	if (mode == 'a' && argv[i][0] == '-')
	{
		if (argv[i][1] == 'a' && argc >= 3)
		{
			strcpy(accfile, argv[++i]);
			argc -= 2;
			i++;
		}
		else
			usage();
	}
	if (mode == 'a')
		getacc(accfile);

	fp = stdin;
	do {
		if (argc > 1 && (fp = fopen(argv[i], "r")) == NULL)
		{
			fprintf(stderr, "%s: can't access file %s\n",
				argv[0], argv[i]);
			exit(1);
		}
		else {
			if (mode == 'a')
				accent(fp);
			else /* c or u mode */
				ced_um(fp);
			fclose(fp);
		}
	} while (++i < argc);
	exit(0);
}

char from[BUFSIZ/8];	/* accent marks placed in text */
char into[BUFSIZ/8];	/* accent marks to be output */

getacc(file)		/* retrieve accent mark definitions */
char *file;
{
	FILE *afp, *fopen();
	char str[BUFSIZ/16];
	register int n;

	if ((afp = fopen(file, "r")) == NULL)
	{
		fprintf(stderr, "can't find accent file: %s\n", file);
		exit(1);
	}
	for (n = 0; fgets(str, BUFSIZ/16, afp) && n < BUFSIZ/8; n++)
	{
		if (strlen(str) == 4)
		{
			from[n] = str[0];
			into[n] = str[2];
		}
		else {
			fprintf(stderr,
				"syntax error in line %d of %s\n", n+1, file);
			fprintf(stderr,
				"usage: <fromchar> <space> <intochar>\n");
			exit(1);
		}
	}
	from[n] = into[n] = NULL;
}

accent(fp)		/* change accent marks into <BS><acc> */
FILE *fp;
{
	register int c, n;

	while ((c = getc(fp)) != EOF)
	{
		n = position(from, c);
		if (n >= 0)
		{
			putchar('\b');
			putchar(into[n]);
		}
		else
			putchar(c);
	}
}

ced_um(fp)		/* change + into cedilla: <BS>, or umlaut: <BS>" */
FILE *fp;
{
	register int c;

	while ((c = getc(fp)) != EOF)
	{
		if (c == '+')
		{
			putchar('\b');
			if (mode == 'c')
				putchar(',');
			if (mode == 'u')
				putchar('"');
		}
		else
			putchar(c);
	}
}

position(str, c)	/* return location of c in str, -1 if not */
char str[], c;
{
	register int i;

	for (i = 0; str[i]; i++)
		if (str[i] == c)
			return(i);
	return(-1);
}
