.TH DICT HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
dict \- split file into dictionary sections
.SH SYNOPSIS
.nf
\fBdict\fP  [ \- ]  filename  [ outfileroot ]
\-: read standard input rather than file
.fi
.SH DESCRIPTION
\fIDict\fP will divide a text into multiple files,
according to the first letter on each line.
It can be used to split up a large concordance
into smaller, more manageable dictionary sections.
This program is akin to the Unix utility \fIsplit\fP,
which divides files into 1000 line portions.
\fIDict\fP reads from the file given in the first argument
(or standard input if the first argument is `\-'),
and writes onto a set of output files,
all beginning with the root given in the second argument.
If no second argument is given, the root defaults to "X".
For every file that is created,
a character is added to the root,
to indicate what letter that file contains.
.PP
Theoretically, it is possible to write 128 different files,
one for each ascii character.
This means that each number goes into its own file,
and that an upper case "A" and a lower case "a"
will end up in different files.
In the case of the \fIkwic\fP program, all keywords are already
mapped to lower case, so there should be 26 or fewer files.
Here is an example of a concordance program using \fIkwic\fP:
.nf
 % kwic text* | sort | dict \- /tmp/OUT
 % edit /tmp/OUT*
 % format /tmp/OUT* | lpr
 % rm /tmp/OUT*
.fi
In the above example, \fIdict\fP makes small files out of one large file,
so that you can edit the concordance until you are happy with it.
The best and most useful concordances are always hand-edited.
.SH "SEE ALSO"
format(hum), kwal(hum), kwic(hum), sort(1), split(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
