(print "****************************************************************************")
(print "Notice: Copyright 1987 by The Benjamin/Cummings Publishing Company, Inc.")
(print "        All rights reserved.  No part of this software may be reproduced,")
(print "        stored in a retrieval system, or transmitted, in any form or by")
(print "        any means, electronic, mechanical, photocopying, recording, or")
(print "        otherwise, without the prior written permission of Benjamin/Cummings")
(print "        Publishing Company.")
(print "****************************************************************************")

;;; -*- Mode:Common-Lisp; Base:10 -*-
;;;UTILITIES.LSP
;;;GENERAL LISP FUNCTIONS

;;P-LINES PRINTS P BLANK LINES.
(DEFUN P-LINES (num)
  (do ((n -1 (1+ n)))
      ((equal n num) t)
    (terpri)))

;;P-SPACES PRINCS NUM SPACES.
(DEFUN P-SPACES (num)
  (do ((n 0 (1+ n)))
      ((or (equal n num)
	   (not (numberp num))) t)
    (princ " ")))


;;PRINC-R OPTIONALLY INDENTS I SPACES, PRINCS STR, AND THEN RETURNS.
(DEFUN PRINC-R (str &optional i)
  (cond (i
	 (p-spaces i)))
  (princ str)
  (terpri))


;;PRINC-I INDENTS NUM SPACES AND PRINCS THE STRING STR.
(DEFUN PRINC-I (str i)
  (p-spaces i)
  (princ str))

;;PPRINT-LIST PRINTS A LIST, AN ELEMENT TO A LINE
(DEFUN PPRINT-LIST (l)
  (terpri)
  (princ-r "(")
  (do ((ll l (cdr ll)))
      ((null ll) t)
    (princ-r (car ll) 2))
  (princ-r ")"))

;;PRINC-ARC PRINTS AN ARC IN STANDARD TEXT NOTATION, GIVEN A NODE AND AN
;;ARC NUMBER.
(DEFUN PRINC-ARC (node arc-num)
  (princ node)
  (princ "/")
  (princ arc-num))

;;PRINT-REG-LIST takes two arguments: a list of registers, and number.  It
;;prints out the list of registers in a standard form with a left-hand
;;margin equal to the number of spaces given in the second argument.  The
;;cursor must begin at the location of the desired margin.
									
(DEFUN PRINT-REG-LIST (reg-list indent)
  (princ "(")
  (princ (car reg-list))
  (cond ((null (cadr reg-list))
	 (princ ")"))
	(t
	 (princ " ")
	 (print-registers (reverse (cdr reg-list))
			  (+ 2 indent (length (prin1-to-string (car reg-list))))))))

;;SLOT-NAME and VAL return the slot-name and value, respectively, of the
;;register given as the argument.  These functions are used by
;;PRINT-REGISTERS which has two arguments: (1) a list of registers and
;;(2)a number.  It prints the registers in a column with a left-hand
;;margin of the number of spaces of the second argument.

(DEFUN SLOT-NAME (reg) (car reg))
(DEFUN VAL (reg) (cadr reg))

(DEFUN PRINT-REGISTERS (regs indent)
  (mapcar #'(lambda (reg)
	      (let ((v (val reg))
		    (i (length (prin1-to-string (slot-name reg)))))
		(princ (slot-name reg))
		(princ " ")
		(cond ((or (atom v) (flat-list v))
		       (princ v))
		      (t
		       (print-reg-list v (+ 1 i indent))))
		(cond ((equal reg (car (last regs)))
		       (princ ")"))
		      (t
		       (terpri)
		       (p-spaces indent)))))
	  regs))


;;PRINT-ATN prints a readable form of a augmented network list
;;structure.  It is dependent upon the three print functions that follow
;;it: PRINT-NODES, PRINT-ARCS, and PRINT-ACTIONS.


;;NODES-WITH-PREFIX returns a list of nodes in network whose names begin
;;with prefix.

(DEFUN NODES-WITH-PREFIX (prefix network node-list)
  (let ((node (first network)))
    (cond ((null network)
	   node-list)
	  ((string-equal prefix
			 (car node)
			 :end2 (length (prin1-to-string prefix)))
	   (nodes-with-prefix prefix
			      (cdr network) 
			      (cons node node-list)))
	  (t
	   (nodes-with-prefix prefix
			      (cdr network)
			      node-list)))))



;;FLAT-LIST RETURNS T IF L IS AN ATOM OR A LIST OF ATOMS, AND NIL OTHERWISE.
(DEFUN FLAT-LIST (l)
  (cond ((null l) 't)
	((atom (first l))
	 (flat-list (cdr l)))
	(t nil)))

;;FIRSTS RETURNS A LIST OF THE FIRST ELEMENT OF EACH MEMBER OF LIST-OF-LISTS
(DEFUN FIRSTS (list-of-lists)
  (mapcar #'first list-of-lists))

;;LIST-ALL LISTS ALL THE MEMBERS OF LST SUCH THAT THEIR CAR EQUALS A.
(DEFUN LIST-ALL (a lst result)
  (let ((first (car lst)))
    (cond ((null lst)
	   (reverse result))
	  ((equal (car first) a)
	   (list-all a (cdr lst) (cons first result)))
	  (t
	   (list-all a (cdr lst) result)))))
