(print "****************************************************************************")
(print "Notice: Copyright 1987 by The Benjamin/Cummings Publishing Company, Inc.")
(print "        All rights reserved.  No part of this software may be reproduced,")
(print "        stored in a retrieval system, or transmitted, in any form or by")
(print "        any means, electronic, mechanical, photocopying, recording, or")
(print "        otherwise, without the prior written permission of Benjamin/Cummings")
(print "        Publishing Company.")
(print "****************************************************************************")

;;; -*- Mode:Common-Lisp; Base:10 -*-
;;;LOGIC-DATA.LSP

;;;Sample Lexicon and Syntax Rules.

(DEFVAR LEXICON '(((isart the))
		  ((isart a))
		  ((isnoun dogs))
		  ((isnoun man))
		  ((isnoun saw))
		  ((isnoun green))
		  ((isname joe))
		  ((isname john))
		  ((isprep in))
		  ((isprep with))
		  ((isverb saw))
		  ((isverb cried))
		  ((isverb broke))))

(DEFVAR SYNTAX-RULES '(((s ?p1 (*s* ?np ?vp) ?p3) ((np ?p1 ?np ?p2)
						   (vp ?p2 ?vp ?p3)))
		       ((np ?p1 (*np* ?art ?noun) ?p3) ((art ?p1 ?art ?p2)
							(noun ?p2 ?noun ?p3)))
		       ((np ?p1 (*np* ?name) ?p2) ((name ?p1 ?name ?p2)))
		       ((pp ?p1 (*pp* ?prep ?np) ?p3) ((prep ?p1 ?prep ?p2)
						       (np ?p2 ?np ?p3)))
		       ((vp ?p1 (*vp* ?verb) ?p2) ((verb ?p1 ?verb ?p2)))
		       ((vp ?p1 (*vp* ?verb ?np) ?p3) ((verb ?p1 ?verb ?p2)
						       (np ?p2 ?np ?p3)))
		       ((vp ?p1 (*vp* ?verb ?np ?pp) ?p4) ((verb ?p1 ?verb ?p2)
							   (np ?p2 ?np ?p3)
							   (pp ?p3 ?pp ?p4)))
		       ((vp ?p1 (*vp* ?verb ?pp) ?p3) ((verb ?p1 ?verb ?p2)
						       (pp ?p2 ?pp ?p3)))
		       
		       ((noun ?n1 (*noun* ?wd1) ?m1) ((word ?wd1 ?n1 ?m1)
						      (isnoun ?wd1)))
		       ((name ?n2 (*name* ?wd2) ?m2) ((word ?wd2 ?n2 ?m2)
						      (isname ?wd2)))
		       ((art ?n3 (*art* ?wd3) ?m3) ((word ?wd3 ?n3 ?m3)
						    (isart ?wd3)))
		       ((verb ?n4 (*verb* ?wd4) ?m4) ((word ?wd4 ?n4 ?m4)
						      (isverb ?wd4)))
		       ((prep ?n5 (*prep* ?wd5) ?m5) ((word ?wd5 ?n5 ?m5)
						      (isprep ?wd5)))))
