
/**********************************************************************
 * $Id: main.c,v 1.2 92/11/30 11:33:10 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include <stdio.h>
#include <math.h>

#include <include/useful.h>
#include <include/simulator.h>
#include "main.h"

static void	activityUpdate ARGS((Unit	unit)) ;
static void	gradientUpdate ARGS((Unit	unit)) ;

static void	calculateNetErrorDeriv ARGS((Net net, ExampleSet exampleSet)) ;
static void	calculateNetError      ARGS((Net net, ExampleSet exampleSet)) ;

static void	initNet   ARGS((Net	net)) ;
static void	deinitNet ARGS((Net	net)) ;
static void	initGroup ARGS((Group	group)) ;

/***********************************************************************
 *	Name:		main 
 *	Description:	the main function, used for the xerion simulator
 *	Parameters:	
 *		int	argc	- the number of input args
 *		char	**argv  - array of argument strings from command 
 *				  line
 *	Return Value:	
 *		int	main	- 0
 ***********************************************************************/
int main(argc, argv)
  int	argc ;
  char	**argv ;
{
  /* Insert any private initialization routines here */
  setCreateNetHook  (initNet) ;
  setDestroyNetHook (deinitNet) ;
  setCreateGroupHook(initGroup) ;

  /* Perform initialization of the simulator */
  IStandardInit(&argc, argv);

  /* Enter loop that reads commands and handles graphics */
  ICommandLoop(stdin, stdout, NULL);

  return 0 ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		initNet 
 *	Description:	sets the error calculation procedures for
 *			a network as well as allocating the memory
 *			for the extension record
 *	Parameters:	
 *		Net	net - the net to act on
 *	Return Value:	NONE
 ***********************************************************************/
static void	initNet(net)
  Net	net ;
{
  /* These MUST be set for the simulator to work properly */
  net->calculateErrorDerivProc = calculateNetErrorDeriv ;
  net->calculateErrorProc      = calculateNetError ;

  net->extension = (NetExtension)calloc(1, sizeof(NetExtensionRec)) ;
}
/**********************************************************************/
static void	deinitNet(net)
  Net	net ;
{
  if (net->extension != NULL)
    free(net->extension) ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		initGroup 
 *	Description:	sets the update procedures for the units in
 *			a group. (forward, backward and weight update)
 *	Parameters:	
 *		Group	group - the group to set the procedures for
 *	Return Value:	NONE
 ***********************************************************************/
static void	initGroup(group)
  Group	group ;
{
  /* These MUST be set for the simulator to work properly */
  group->unitActivityUpdateProc = forward ;
  group->unitGradientUpdateProc = backward ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		update???
 *	Description:	update procedures for units
 *	Parameters:	
 *		Unit	unit - the unit of concern
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static Proc	activityUpdate(unit)
  Unit	unit ;
{
  /***
   * Insert in here whatever procedure is used to calculate
   * a unit's activity.
   */
}
/**********************************************************************/
static Proc	gradientUpdate(unit)
  Unit	unit ;
{
  /***
   * Insert in here whatever procedure is used to calculate
   * a unit's (and its incoming links') derivative fields.
   */
}
/**********************************************************************/


/***********************************************************************
 *	Name:		calculateNetErrorDeriv
 *	Description:	gradient calculation procedure for backprop net
 *			It processes 'MbatchSize(net)' examples
 *	Parameters:	
 *		Net		net        - the net to use
 *		ExampleSet	exampleSet - the examples to use
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void	calculateNetErrorDeriv(net, exampleSet)
  Net		net ;
  ExampleSet	exampleSet ;
{
  /***
   * Insert in here whatever procedure is used to calculate a net's
   * error and associated derivativs on a batch of examples.
   */
}
/**********************************************************************/


/***********************************************************************
 *	Name:		calculateNetError
 *	Description:	error calculation procedure for backprop net
 *			It processes 'MbatchSize(net)' examples
 *	Parameters:	
 *		Net		net        - the net to use
 *		ExampleSet	exampleSet - the examples to use
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void	calculateNetError(net, exampleSet)
  Net		net ;
  ExampleSet	exampleSet ;
{
  /***
   * Insert in here whatever procedure is used to calculate a net's
   * error on a batch of examples.
   */
}
/**********************************************************************/
