
/**********************************************************************
 * $Id: command.c,v 1.3 92/11/30 11:33:09 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <xerion/useful.h>
#include <xerion/simulator.h>
#include <xerion/commands.h>

/***********************************************************************
 *	Name:		command_template
 *	Description:	Template for user commands. Any function with
 *			the name command_<name> will be extracted
 *			automatically from the object module by
 *			extract-commands.
 *		int	tokc    - the number of command line tokens
 *		char	*tokv[] - the vector of tokens
 *	Return Value:	
 *		int	command_template - 0 on failure, 1 on success
 ***********************************************************************/
int	command_template(tokc, tokv)
  int	tokc ;
  char	**tokv ;
{

  IUsage("template options");
  if (GiveHelp(tokc)) {
    ISynopsis("Template for user command");
    IHelp
      (IHelpArgs,
       "Summary of how the command works.",
       "...",
       "EXAMPLES",
       "SEE ALSO",
       NULL) ;
    return 1 ;
  }

  /* Parse any command line options */

  /***
   * Do whatever you want in here. 
   * Note that all writing should be to external FILE * 'dout'.
   */
  fprintf(dout,"Command 'template' at your service!\n");

  /***
   * In case of error call
   *   IErrorAbort("%s: error is with %d", tokv[0], 88);
   * This call returns you to the command prompt and prints the error message
   */

  return 1 ;
}
/**********************************************************************/
