
/**********************************************************************
 * $Id: xkick.c,v 1.3 92/06/16 16:48:55 drew Exp $
 **********************************************************************/

/**********************************************************************
 *	Copyright 1990,1991,1992 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <xerion/config.h>
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>

static String	fallbacks[] = {
  "*dialog.label:	Click to Interrupt",
  "*kick.label:		Interrupt",
  NULL
} ;

static Widget	initX	     ARGS((int *argc, char *argv[])) ;
static Widget	createPopup ARGS((Widget parent, int pid)) ;
static void	kickCB	     ARGS((Widget, XtPointer, XtPointer)) ;

int	main(argc, argv)
  int	argc ;
  char	*argv[] ;
{
  int		pid ;
  Widget	toplevel, popup ;

  toplevel = initX(&argc, argv) ;

  if (argc != 2) {
    fprintf(stderr, "usage: %s [X options] pid\n", argv[0]) ;
    exit(1) ;
  } 

  pid = atoi(argv[1]) ;
  if (pid <= 0 ) {
    fprintf(stderr, "bad process id: %s\n", argv[1]) ;
    exit(1) ;
  }

  popup = createPopup(toplevel, pid) ;
  
  XtPopup(popup, XtGrabExclusive) ;

  XtAppMainLoop(XtWidgetToApplicationContext(toplevel)) ;
}

static Widget	initX(argc, argv) 
  int		*argc ;
  char		*argv[] ;
{
  Widget	toplevel ;
  XtAppContext	app ;

  toplevel = XtAppInitialize(&app, "Xerion", 
			      NULL, 0, argc, argv, fallbacks, NULL, 0) ;

  return toplevel ;
}

static Widget	createPopup(parent, pid)
  Widget	parent ;
  int		pid ;
{
  Widget	popup, dialog ;

  popup = XtVaCreatePopupShell("popup", transientShellWidgetClass, parent, 
			       NULL) ;
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, popup, 
				   NULL) ;
  XawDialogAddButton(dialog, "kick", kickCB, (XtPointer)pid) ;

  return popup ;
}

static void	kickCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  int	pid = (int)clientData ;

  if (pid > 0 )
    kill(pid, SIGINT) ;
#if 0
  exit(0) ;
#endif
}
