
/**********************************************************************
 * $Id: SelectionP.h,v 1.3 92/11/30 11:32:58 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/* Private definitions for Selection widget */

#ifndef _SelectionP_h
#define _SelectionP_h

#include <X11/Xaw/FormP.h>
#include <xerion/Selection.h>

typedef struct {
  void	*extension;
} SelectionClassPart;

typedef struct _SelectionClassRec {
  CoreClassPart		core_class;
  CompositeClassPart	composite_class;
  ConstraintClassPart	constraint_class;
  FormClassPart		form_class;
  SelectionClassPart	selection_class;
} SelectionClassRec;

extern SelectionClassRec selectionClassRec;

typedef struct _SelectionPart {
  /* resources */
  XtCallbackList	callback ;	/* the callback for selection */
  String		listLabel;	/* string for the list label */
  String		*list ;		/* the list to select from */
  int			numberStrings ;	/* number of strings in list */
  Dimension		listHeight ; 	/* the height of the viewport */
  String		valueLabel;	/* string for the value label */
  String		value;		/* the value to display */

  /* private data */
  Widget		listLabelW;	/* widget to display list label */
  Widget		viewportW;	/* widget to hold list widget */
  Widget		listW;		/* widget to hold the list */
  Widget		valueLabelW;	/* widget to display value label */
  Widget		valueW;		/* user response TextWidget */
} SelectionPart;

typedef struct _SelectionRec {
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  FormPart		form;
  SelectionPart		selection;
} SelectionRec;

typedef struct {
  void	*extension ;
} SelectionConstraintsPart;

typedef struct _SelectionConstraintsRec {
  FormConstraintsPart		form;
  SelectionConstraintsPart	selection;
} SelectionConstraintsRec, *SelectionConstraints;

#endif /* _SelectionP_h */
