
/**********************************************************************
 * $Id: Selection.h,v 1.2 92/11/30 11:32:57 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _Selection_h
#define _Selection_h

#include <xerion/config.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>


/***********************************************************************
 *
 * Selection Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	computed at create
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	computed at create
 x		     Position		Position	0
 y		     Position		Position	0

 label		     Label		String		NULL
 list		     List		String *	NULL
 numberStrings	     NumberStrings	int		0
 listHeight	     ListHeight		Dimension	200
 valueLabel	     Label		String		NULL
 value		     Value		String		NULL
 callback	     Callback		Pointer		NULL
*/

#define XtNlistHeight	"listHeight"
#define XtNlistLabel	"listLabel"
#define XtNvalueLabel	"valueLabel"

#define XtCListHeight	"ListHeight"
#define XtCListLabel	"ListLabel"
#define XtCValueLabel	"ValueLabel"

typedef struct _SelectionClassRec	*SelectionWidgetClass;
typedef struct _SelectionRec		*SelectionWidget;

extern WidgetClass selectionWidgetClass;

extern Widget XtSelectionAddButton(); /* parent, name, function, param */
    /* Widget parent; */
    /* String name; */
    /* XtCallback function; */
    /* XtPointer param; */

extern char *XtSelectionGetValueString(); /* w */
    /* Widget w; */

extern void XtSelectionSetValueString(); /* w */
    /* Widget w; */

extern XawListReturnStruct *XtSelectionGetSelected(); /* w */
    /* Widget w; */

extern void XtSelectionHighlight(); /* w, item */
    /* Widget w; */
    /* int    item; */

#endif				/* _Selection_h */
/* DON'T ADD STUFF AFTER THIS #endif */
