
/**********************************************************************
 * $Id: RowColumnP.h,v 1.2 92/11/30 11:32:55 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/* Private definitions for RowColumn widget */

#ifndef _RowColumnP_h
#define _RowColumnP_h

#include <X11/Xaw/FormP.h>
#include <xerion/RowColumn.h>

typedef struct {int empty;} RowColumnClassPart;

typedef struct _RowColumnClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    RowColumnClassPart	rowColumn_class;
} RowColumnClassRec;

extern RowColumnClassRec rowColumnClassRec;

typedef struct _RowColumnPart {
    /* resources */
    Dimension		columnWidth ;   /* the width of each column */
    int			horizDistance ; /* the distance between columns */
    Dimension		rowHeight ;     /* the height of each row */
    int			vertDistance ;	/* the distance between rows */
} RowColumnPart;

typedef struct _RowColumnRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    RowColumnPart	rowColumn;
} RowColumnRec;

typedef struct {
    int			row ;		/* the row to place the child in */
    int			column ;	/* the column to place the child in */
} RowColumnConstraintsPart;

typedef struct _RowColumnConstraintsRec {
    FormConstraintsPart	     form;
    RowColumnConstraintsPart rowColumn;
} RowColumnConstraintsRec, *RowColumnConstraints;

#endif /* _RowColumnP_h */
