
/**********************************************************************
 * $Id: RowColumn.h,v 1.2 92/11/30 11:32:54 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _RowColumn_h
#define _RowColumn_h

#include <xerion/config.h>
#include <X11/Constraint.h>

/***********************************************************************
 *
 * RowColumn Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 columnWidth	     ColumnWidth	Dimension	0
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	computed at realize
 horizDistance       HorizDistance	int		4
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 rowHeight	     RowHeight		Dimension	0
 sensitive	     Sensitive		Boolean		True
 vertDistance        VertDistance	int		4
 width		     Width		Dimension	computed at realize
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* Constraint parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 row		     Row		int		0
 column		     Column		int		0

*/

#define XtNcolumn		"column"
#define XtNcolumnWidth		"columnWidth"
#define XtNhorizDistance	"horizDistance"
#define XtNrow			"row"
#define XtNrowHeight		"rowHeight"
#define XtNvertDistance		"vertDistance"

#define XtCColumn		"Column"
#define XtCColumnWidth		"ColumnWidth"
#define XtCHorizDistance	"HorizDistance"
#define XtCRow			"Row"
#define XtCRowHeight		"RowHeight"
#define XtCVertDistance		"VertDistance"

typedef struct _RowColumnClassRec	*RowColumnWidgetClass;
typedef struct _RowColumnRec		*RowColumnWidget;

extern WidgetClass rowColumnWidgetClass;
 
#endif				/* _RowColumn_h */

