
/**********************************************************************
 * $Id: RowColumn.c,v 1.2 92/11/30 11:32:52 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>

#include "RowColumnP.h"

#define Offset(field) XtOffset(RowColumnConstraints, rowColumn.field)
static XtResource rowColumnConstraintResources[] = {
    {XtNcolumn, XtCColumn, XtRInt, sizeof(int),
	Offset(column), XtRString, "0"},
    {XtNrow, XtCRow, XtRInt, sizeof(int),
	Offset(row), XtRString, "0"},
};
#undef Offset

#define offset(field) XtOffset(RowColumnWidget, rowColumn.field)
static XtResource resources[] = {
  {XtNcolumnWidth,   XtCColumnWidth,   XtRDimension, sizeof(Dimension),
     offset(columnWidth),   XtRString, "0"},
  {XtNhorizDistance, XtCHorizDistance, XtRInt,       sizeof(int),
     offset(horizDistance), XtRString,"4"},
  {XtNrowHeight,     XtCRowHeight,     XtRDimension, sizeof(Dimension),
     offset(rowHeight),     XtRString,"0"},
  {XtNvertDistance,  XtCVertDistance,  XtRInt,       sizeof(int),
     offset(vertDistance),  XtRString,"4"},
  {XtNheight,        XtCHeight,        XtRDimension, sizeof(Dimension),
     XtOffset(RowColumnWidget, core.height),           XtRString,   "20"},
  {XtNwidth,        XtCWidth,         XtRDimension, sizeof(Dimension),
     XtOffset(RowColumnWidget, core.width),            XtRString,   "20"},
};
#undef Offset

/* Private Functions and procedures */
static void	Initialize() ;
static void	ConstraintInitialize() ;
static Boolean	ConstraintSetValues() ;
static Boolean	SetValues() ;

RowColumnClassRec rowColumnClassRec = {
  {				/* core_class fields */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "RowColumn",
    /* widget_size        */    sizeof(RowColumnRec),
    /* class_initialize   */    XawInitializeWidgetSet,
    /* class_part init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
    },
  {				/* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* extension          */   NULL
    },
  {				/* constraint_class fields */
    /* subresourses       */   rowColumnConstraintResources,
    /* subresource_count  */   XtNumber(rowColumnConstraintResources),
    /* constraint_size    */   sizeof(RowColumnConstraintsRec),
    /* initialize         */   ConstraintInitialize,
    /* destroy            */   NULL,
    /* set_values         */   ConstraintSetValues,
    /* extension          */   NULL
    },
  {				/* form_class fields */
    /* layout             */   XtInheritLayout
    },
  {				/* rowColumn_class fields */
    /* empty              */   0
    }
};

WidgetClass rowColumnWidgetClass = (WidgetClass)&rowColumnClassRec ;
  

/***********************************************************************
 *	Name:		Initialize
 *	Description:	initialization routine for the RowColumn widget
 *			Doesn't do anything right now.
 *	Parameters:	
 *		Widget		request - the requested config for the widget
 *		Widget		new - the version that we will accept
 *		ArgList		args - the args passed in at creation
 *		Cardinal	*numArgs - the number of args
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void	Initialize(request, new, args, numArgs)
  Widget	request ;
  Widget	new ;
  ArgList	args ;
  Cardinal	*numArgs ;
{
#ifdef DEBUG
  fprintf(stderr, "Initialize called\n") ;
#endif
}
/**********************************************************************/


/***********************************************************************
 *	Name:		PositionChild
 *	Description:    sets the constraint values for a child of a row
 *			column widget
 *	Parameters:	
 *		Widget	widget - the child to position
 *	Return Value:	NONE
 ***********************************************************************/
static Boolean	PositionChild(widget)
  Widget	widget ;
{
  Position		dx, dy ;
  Boolean		moved ;
  RowColumnWidget 	rc = (RowColumnWidget)widget->core.parent ;
  RowColumnConstraints 	constraint = 
    (RowColumnConstraints)((Widget)widget)->core.constraints ;

  dx = (rc->rowColumn.columnWidth + rc->rowColumn.horizDistance)
    *constraint->rowColumn.column + rc->rowColumn.horizDistance ;
  dy = (rc->rowColumn.rowHeight + rc->rowColumn.vertDistance)
    *constraint->rowColumn.row + rc->rowColumn.vertDistance ;
  /* HACK: make sure widgets in negative rows and columns don't show */
  if (constraint->rowColumn.column < 0)
    dx *= 2 ;
  if (constraint->rowColumn.row < 0)
    dy *= 2 ;

  if (dx != constraint->form.dx || dx != constraint->form.dx)
    moved = TRUE ;
  else 
    moved = FALSE ;

  constraint->form.dx = dx ;
  constraint->form.dy = dy ;

  XtMoveWidget(widget, dx, dy) ;

  return moved ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		ConstraintInitialize
 *	Description:	initializes the constraints for the children
 *			of a row column widget. (i.e. it places them
 *			in the proper row and column.
 *	Parameters:	
 *		Widget		request - the requested config for the widget
 *		Widget		new - the version that we will accept
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void	ConstraintInitialize(request, new)
  Widget	request ;
  Widget	new ;
{
  RowColumnConstraints 	constraint = 
    (RowColumnConstraints)((Widget)new)->core.constraints ;

  constraint->form.top       = XtChainTop ;
  constraint->form.bottom    = XtChainTop ;
  constraint->form.left      = XtChainLeft ;
  constraint->form.right     = XtChainLeft ;

  constraint->form.vert_base  = NULL ;
  constraint->form.horiz_base = NULL ;

  PositionChild(new) ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		SetValues
 *	Description:	does the set values for the RowColumn
 *			Moves children around if necessary
 *	Parameters:	
 *		Widget		current - the existing widget
 *		Widget		request - the requested config for the widget
 *		Widget		new - the version that we will accept
 *		ArgList		args - the args passed in at creation
 *		Cardinal	*numArgs - the number of args
 *	Return Value:	
 *		Boolean	SetValues - False
 ***********************************************************************/
static Boolean	SetValues(current, request, new, args, numArgs)
  Widget	current ;
  Widget	request ;
  Widget	new ;
  ArgList 	args ;
  Cardinal 	*numArgs ;
{
  RowColumnWidget	newRC = (RowColumnWidget)new ;
  RowColumnWidget	oldRC = (RowColumnWidget)current ;

  if (   newRC->rowColumn.columnWidth   != oldRC->rowColumn.columnWidth 
      || newRC->rowColumn.rowHeight     != oldRC->rowColumn.rowHeight
      || newRC->rowColumn.vertDistance  != oldRC->rowColumn.vertDistance
      || newRC->rowColumn.horizDistance != oldRC->rowColumn.horizDistance) {
    int		idx ;
    Widget	child ;
    for (idx = 0 ; idx < newRC->composite.num_children ; ++idx) {
      child = newRC->composite.children[idx] ;
      if (XtIsManaged(child))
	PositionChild(child) ;
    }
    return TRUE ;
  } else {
    return FALSE ;
  }
}
/**********************************************************************/


/***********************************************************************
 *	Name:		ConstraintSetValues
 *	Description:	does the constraint set values for the RowColumn 
 *			children. It handle changes in row and column
 *	Parameters:	
 *		Widget		current - the existing widget
 *		Widget		request - the requested config for the widget
 *		Widget		new - the version that we will accept
 *		ArgList		args - the args passed in at creation
 *		Cardinal	*numArgs - the number of args
 *	Return Value:	
 *		Boolean	SetValues - False
 ***********************************************************************/
static Boolean	ConstraintSetValues(current, request, new, args, numArgs)
  Widget	current ;
  Widget	request ;
  Widget	new ;
  ArgList 	args ;
  Cardinal 	*numArgs ;
{
  return PositionChild(new) ;
}
/**********************************************************************/
