
/**********************************************************************
 * $Id: PlotP.h,v 1.2 92/11/30 11:32:51 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/* Private definitions for Plot widget */

#ifndef _PlotP_h
#define _PlotP_h

#include <X11/Xaw/FormP.h>
#include <xerion/Plot.h>

typedef struct {
  int	empty ;
} PlotClassPart ;

typedef struct _PlotClassRec {
  CoreClassPart		core_class ;
  CompositeClassPart	composite_class ;
  ConstraintClassPart	constraint_class ;
  FormClassPart		form_class ;
  PlotClassPart		plot_class ;
} PlotClassRec;

extern PlotClassRec plotClassRec ;

typedef struct _PlotPart {
  /* resources */
  String		label ;		/* string for the label */
  String		format ;	/* format for printing ranges */
  float			*canvasXOffset ;
  float			*canvasYOffset ;
  float			*canvasWidth ;
  float			*canvasHeight ;

  /* private data */
  Widget		canvasWidget;	/* widget to hold the canvas */
  Widget		labelWidget ;	/* widget to hold the label */
  Widget		xScaleWidget[2] ; /* widgets to hold the x scales */
  Widget		yScaleWidget[2] ; /* widgets to hold the y scales */
} PlotPart;

typedef struct _PlotRec {
  CorePart		core ;
  CompositePart		composite ;
  ConstraintPart	constraint ;
  FormPart		form ;
  PlotPart		plot ;
} PlotRec ;

typedef struct {
  void	*extension ;
} PlotConstraintsPart ;

typedef struct _PlotConstraintsRec {
  FormConstraintsPart	form;
  PlotConstraintsPart	plot;
} PlotConstraintsRec, *PlotConstraints;

#endif /* _PlotP_h */
