
/**********************************************************************
 * $Id: Plot.h,v 1.2 92/11/30 11:32:50 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _Plot_h
#define _Plot_h

#include <xerion/config.h>

#include <X11/Xaw/Form.h>
#include "Canvas.h"

/***********************************************************************
 *
 * Plot Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 foreground	     Foreground		Pixel		XtDefaultForeground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 callback	     Callback		Pointer		NULL
 height		     Height		Dimension	0
 label		     Label		String		NULL
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

 canvasXOffset	     canvasOffset	FloatPointer	0.0
 canvasYOffset	     canvasOffset	FloatPointer	0.0
 canvasWidth	     canvasDimension	FloatPointer	1.0
 canvasHeight	     canvasDimension	FloatPointer	1.0
 format		     XtNformat		XtCFormat	"% 8g"
*/

#define XtNformat	"format"
#define XtCFormat	"Format"

typedef struct _PlotClassRec	*PlotWidgetClass;
typedef struct _PlotRec		*PlotWidget;

extern WidgetClass plotWidgetClass;

extern void XtPlotAddPoints() ;
  /*	Widget	  w ;
   *	CanvasPoint *points ;
   *	int	  numPoints ;
   *	Boolean	  redraw ;
   */

extern void XtPlotAddSegments() ;
  /*	Widget	  w ;
   *	CanvasSegment *segments ;
   *	int	  numSegments ;
   *	Boolean	  redraw ;
   */

extern void XtPlotAddCircles() ;
  /*	Widget	   w ;
   *	CanvasCircle *circles ;
   *	int	   numCircles ;
   *	Boolean	   redraw ;
   */

extern void XtPlotRedraw() ;
  /*	Widget	  w ;
   */

extern void XtPlotClear() ;
  /*	Widget	  w ;
   *	Boolean	  redraw ;
   */

#endif /* _Plot_h */
/* DON'T ADD STUFF AFTER THIS #endif */
