
/**********************************************************************
 * $Id: Network.h,v 1.2 92/11/30 11:32:47 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _Network_h
#define _Network_h

#include <xerion/config.h>

/***********************************************************************
 *
 * Network Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	20
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	20
 x		     Position		Position	0
 y		     Position		Position	0

 unitBackgroundStyle BackgroundStyle	XtStyle		XtShadow
 unitBackgroundColor Background		Pixel		XtDefaultBackground
 negativeColor	     NegativeColor	Pixel		XtDefaultForeground
 positiveColor	     PositiveColor	Pixel		XtDefaultBackground

 unitHeight	     UnitDimension	Dimension	20
 unitWidth	     UnitDimension	Dimension	20
 unitBorderWidth     BorderWidth	Dimension	1
 unitSep	     UnitSep		Dimension	3
 rowColumnMode	     RowColumnMode	Boolean		True
 numUnits	     NumUnits		Int		0
 unitArray	     UnitArray		UnitRec *	NULL
 maxValue	     MaxValue		FloatPtr	see Note: 1
 fixedMax	     FixedMax		Boolean		True
 increment	     Increment		int		10
 queryCallback	     Callback		Pointer		NULL
 motionCallback	     Callback		Pointer		NULL
 changeValueCallback Callback		Pointer		NULL

Note 1: The maximum value is automatically calculated unless the resource
	"fixedMax" is True, in which case it is the users responsibility
	to set it.
*/


#define XtNunitBackgroundStyle	"unitBackgroundStyle"
#define XtNunitBackground	"unitBackground"
#define XtNunitBorderWidth	"unitBorderWidth"
#define XtNnegativeColor	"negativeColor"
#define XtNpositiveColor	"positiveColor"
#define XtNunitHeight		"unitHeight"
#define XtNunitWidth		"unitWidth"
#define XtNunitSep		"unitSep"
#define XtNrowColumnMode	"rowColumnMode"
#define XtNnumUnits		"numUnits"
#define XtNunitArray		"unitArray"
#define XtNmaxValue		"maxValue"
#define XtNfixedMax		"fixedMax"
#define XtNincrement		"increment"
#define XtNmotionCallback	"motionCallback"
#define XtNqueryCallback	"queryCallback"
#define XtNchangeValueCallback	"changeValueCallback"

#define XtCBackgroundStyle	"BackgroundStyle"
#define XtCNegativeColor	"NegativeColor"
#define XtCPositiveColor	"PositiveColor"
#define XtCUnitDimension 	"UnitDimension"
#define XtCUnitSep	 	"UnitSep"
#define XtCRowColumnMode	"RowColumnMode"
#define XtCNumUnits		"NumUnits"
#define XtCUnitArray		"UnitArray"
#define XtCMaxValue		"MaxValue"
#define XtCFixedMax		"FixedMax"
#define XtCIncrement		"Increment"

typedef enum {XtPlain, XtShadow, XtLines, XtLines2, XtWeave, XtSolid} XtStyle ;

#define XtRStyle	"Style"
#define XtEplain	"plain"
#define XtEshadow	"shadow"
#define XtElines	"lines"
#define XtElines2	"lines2"
#define XtEweave	"weave"
#define XtEsolid	"solid"

#define XtRFloatPointer	"FloatPointer"

typedef struct _UnitDisplayRec {
  int		row ;
  int		column ;
  float 	value ;
  caddr_t	userData ;
} UnitDisplayRec ;

typedef struct _NetworkReturnStruct {
  int			x ;
  int			y ;
  int			index ;
  UnitDisplayRec	unitRec ;
} NetworkReturnStruct ;

typedef struct _NetworkClassRec	*NetworkWidgetClass;
typedef struct _NetworkRec	*NetworkWidget;

extern WidgetClass networkWidgetClass;

extern void XtNetworkSetUnit(); /* w, idx, recPtr */
    /* Widget	w;
     * int	idx ;
     * UnitRec	*recPtr ;
     */
extern void XtNetworkSetUnits(); /* w, recPtr */
    /* Widget	w;
     * UnitRec	*recPtr ;
     */
extern UnitDisplayRec *XtNetworkGetUnit(); /* w, idx */
    /* Widget	w;
     * int	idx ;
     */

#endif /* _Network_h */
/* DON'T ADD STUFF AFTER THIS #endif */
