
/**********************************************************************
 * $Id: MenuPane.c,v 1.2 92/11/30 11:32:42 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>

#include "MenuPaneP.h"

/* Private Functions and procedures */
static void	ChangeManaged () ;

static XtResource resources[] = {
  {XtNorientation, XtCOrientation, XtROrientation, sizeof(XtOrientation),
     XtOffset(MenuPaneWidget, box.orientation), XtROrientation, XtEhorizontal},
} ;

MenuPaneClassRec menuPaneClassRec = {
  {				/* core_class fields */
    /* superclass         */    (WidgetClass) &boxClassRec,
    /* class_name         */    "MenuPane",
    /* widget_size        */    sizeof(MenuPaneRec),
    /* class_initialize   */    XawInitializeWidgetSet,
    /* class_part init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    NULL,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
    },
  {				/* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   ChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* extension          */   NULL
    },
  {				/* box_class fields */
    /* empty             */   0
    },
  {				/* menuPane_class fields */
    /* extension          */   NULL
    }
};

WidgetClass menuPaneWidgetClass = (WidgetClass)&menuPaneClassRec ;


/*********************************************************************
 *	Name:		ChangeManaged
 *	Description:	the change managed procedure for the menu pane.
 *			It calls it's superclass's changeManaged proc
 *			then if it tried to shrink the width, it tries
 *			to enlarge it back to the original size
 *	Parameters:
 *	  Widget	w - the menuPane widget
 *	Return Value:
 *	  static void	ChangeManaged - NONE
 *********************************************************************/
static void	ChangeManaged(w)
  Widget	w ;
{
  MenuPaneWidget	menuPane = (MenuPaneWidget)w ;
  Dimension		width    = menuPane->core.width ;
  XtWidgetGeometry	request ;
  XtGeometryResult	result ;

  (*((CompositeClassRec *)menuPaneClassRec.core_class.superclass)->composite_class.change_managed)
    (w) ;
  if (width > menuPane->core.width) {
    request.width = width ;
    request.request_mode = CWWidth ;
    do {
      result = XtMakeGeometryRequest(w, &request, &request) ;
    } while (result == XtGeometryAlmost) ;
  }
}
/********************************************************************/
