
/**********************************************************************
 * $Id: GraphP.h,v 1.2 92/11/30 11:32:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _GraphP_h
#define _GraphP_h

#include <X11/CoreP.h>
#include <xerion/Graph.h>

/* define unique representation types not found in <X11/StringDefs.h> */
#define XtRGraphResource		"GraphResource"

typedef struct {
    int empty;
} GraphClassPart;

typedef struct _GraphClassRec {
    CoreClassPart	core_class;
    GraphClassPart	graph_class;
} GraphClassRec;

extern GraphClassRec graphClassRec;

typedef struct {
    /* resources */
    Pixel	foregroundPixel ; /* pixel for drawing the foreground */
    Dimension	internalBorder ;/* The width inside the border that we draw */
    XFontStruct	*font ;		/* The font to use for the label */
    String	label ;		/* Th graph label */
    String	minFormat ;	/* format for printing max value */
    String	maxFormat ;	/* format for printing min value */
    float	*minValue ;	/* minimum value for graph */
    float	*maxValue ;	/* maximum value for graph */
    Boolean	fixedMin ;	/* is the minimum value fixed ? */
    Boolean	fixedMax ;	/* is the maximum value fixed ? */
    int		numColumns ;	/* the number of columns to display */
    int		jumpScroll ;	/* the number of columns to jump when scrolling */
    /* private state */
    GC		gc ;		/* graphical context for regular drawing */
    GC		graphGC ;	/* graphical context for the graph */
    int		graphHeight ;	/* height of a single graph */
    int		graphWidth ;	/* width of a single graph */
    int		labelWidth ;	/* maximum width of the label */
    int		currentColumn ;	/* the last column drawn */
    float	stepSize ;	/* the step between each point in the graph */
    float	*values ;	/* the plotted values */
} GraphPart;

typedef struct _GraphRec {
    CorePart	core;
    GraphPart	graph;
} GraphRec;

#endif				/* _GraphP_h */
