
/**********************************************************************
 * $Id: Graph.h,v 1.2 92/11/30 11:32:40 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _Graph_h
#define _Graph_h

#include <xerion/config.h>

/****************************************************************
 *
 * Graph widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	100
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	200
 x		     Position		Position	0
 y		     Position		Position	0

 foreground	     Foreground		Pixel		XtDefaultForeground
 internalBorder	     Width		Dimension	4
 font		     Font		XFontStruct*	XtDefaultFont
 numColumns	     NumColumns		Int		50
 jumpScroll	     JumpScroll		Int		25
 label		     Label		String 		NULL
 minValue	     MinValue		float*		NULL
 maxValue	     MaxValue		float*		NULL
 fixedMin	     FixedScale		Boolean		False
 fixedMax	     FixedScale		Boolean		False
 minFormat	     XtNminFormat	XtCFormat	"% f "
 maxFormat	     XtNmaxFormat	XtCFormat	"% f "
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNminFormat		"minFormat"
#define XtNmaxFormat		"maxFormat"
#define XtNnumColumns		"numColumns"
#define XtNjumpScroll		"jumpScroll"
#define XtNminValue		"minValue"
#define XtNmaxValue		"maxValue"
#define XtNinternalBorder	"internalBorder"
#define XtNfixedMin		"fixedMin"
#define XtNfixedMax		"fixedMax"

#define XtCFormat		"Format"
#define XtCNumColumns		"NumColumns"
#define XtCJumpScroll		"JumpScroll"
#define XtCMinValue		"MinValue"
#define XtCMaxValue		"MaxValue"
#define XtCInternalBorder	"InternalBorder"
#define XtCFixedScale		"FixedScale"

/* declare specific GraphWidget class and instance datatypes */

typedef struct _GraphClassRec*		GraphWidgetClass;
typedef struct _GraphRec*		GraphWidget;

/* declare the class constant */

extern WidgetClass graphWidgetClass;

extern void	graphAddValue() ;  /* Widget w, float value */
extern void	graphReset() ;     /* Widget w */
extern void     graphRescale() ;   /* Widget w */
extern void     graphShift() ;     /* Widget w */

#endif				/* _Graph_h */
