
/**********************************************************************
 * $Id: CanvasP.h,v 1.2 92/11/30 11:32:37 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/* Private definitions for Canvas widget */

#ifndef _CanvasP_h
#define _CanvasP_h

#include <xerion/Canvas.h>

typedef void	(*CanvasDrawProc)() ;
  /* Widget	widget ;
   * void	*things ;
   * int	numThings ;
   */
typedef Boolean	(*CanvasRescaleProc)() ;
  /* Widget	widget ;
   * void	*things ;
   * int	numThings ;
   */

typedef struct {
  CanvasDrawProc	drawPointsProc ;
  CanvasDrawProc	drawSegmentsProc ;
  CanvasDrawProc	drawCirclesProc ;
  CanvasRescaleProc	rescalePointsProc ;
  CanvasRescaleProc	rescaleSegmentsProc ;
  CanvasRescaleProc	rescaleCirclesProc ;
  void	*extension ;
} CanvasClassPart ;

typedef struct _CanvasClassRec {
    CoreClassPart	core_class ;
    CanvasClassPart	canvas_class ;
} CanvasClassRec ;

extern CanvasClassRec canvasClassRec ;

typedef struct _CanvasPart {
  /* resources */
  Pixel		foregroundColor ;
  Dimension	lineWidth ;
  Dimension	pointSize ;
  Boolean	autoScale ;	/* scale automatically to hold data */
  float		*canvasXOffset ;
  float		*canvasYOffset ;
  float		*canvasWidth ;
  float		*canvasHeight ;

  /* private data */
  Boolean	changeGC ;
  Boolean	scaleChanged ;
  Boolean	resetMinMax ;
  GC		foregroundGC ;
  CanvasPoint	*points ;
  int		numPoints ;
  CanvasSegment	*segments ;
  int		numSegments ;
  CanvasCircle	*circles ;
  int		numCircles ;
} CanvasPart ;

typedef struct _CanvasRec {
    CorePart		core ;
    CanvasPart		canvas ;
} CanvasRec ;

#endif /* _CanvasP_h */
