
/**********************************************************************
 * $Id: Canvas.h,v 1.2 92/11/30 11:32:36 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _Canvas_h
#define _Canvas_h

#include <xerion/config.h>

/***********************************************************************
 *
 * Canvas Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 foreground	     Foreground		Pixel		XtDefaultForeground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 callback	     Callback		Pointer		NULL
 height		     Height		Dimension	300
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	300
 x		     Position		Position	0
 y		     Position		Position	0

 lineWidth	     LineWidth		Dimension	1
 pointSize	     PointSize		Dimension	4
 autoScale	     AutoScale		Boolean		FALSE
 canvasXOffset	     canvasOffset	FloatPointer	0.0
 canvasYOffset	     canvasOffset	FloatPointer	0.0
 canvasWidth	     canvasDimension	FloatPointer	1.0
 canvasHeight	     canvasDimension	FloatPointer	1.0
*/


#define XtNcanvasXOffset	"canvasXOffset"
#define XtNcanvasYOffset	"canvasYOffset"
#define XtNcanvasWidth		"canvasWidth"
#define XtNcanvasHeight		"canvasHeight"
#define XtNlineWidth		"lineWidth"
#define XtNpointSize		"pointSize"
#define XtNautoScale		"autoScale"

#define XtCCanvasOffset		"CanvasOffset"
#define XtCCanvasDimension	"CanvasDimension"
#define XtCLineWidth		"LineWidth"
#define XtCPointSize		"PointSize"
#define XtCAutoScale		"AutoScale"

#define XtRFloatPointer		"FloatPointer"

typedef struct _CanvasPointRec {
  float		x ;
  float		y ;
} CanvasPoint ;

typedef struct _CanvasSegmentRec {
  float		x1, x2 ;
  float		y1, y2 ;
} CanvasSegment ;

typedef struct _CanvasCircleRec {
  float		x ;
  float		y ;
  float		radius ;
} CanvasCircle ;

typedef struct _CanvasClassRec	*CanvasWidgetClass;
typedef struct _CanvasRec	*CanvasWidget;

extern WidgetClass canvasWidgetClass;

extern void XtCanvasAddPoints() ;
  /*	Widget	  w ;
   *	CanvasPoint *points ;
   *	int	  numPoints ;
   *	Boolean	  redraw ;
   */

extern void XtCanvasAddSegments() ;
  /*	Widget	  w ;
   *	CanvasSegment *segments ;
   *	int	  numSegments ;
   *	Boolean	  redraw ;
   */

extern void XtCanvasAddCircles() ;
  /*	Widget	   w ;
   *	CanvasCircle *circles ;
   *	int	   numCircles ;
   *	Boolean	   redraw ;
   */

extern void XtCanvasRedraw() ;
  /*	Widget	  w ;
   */

extern void XtCanvasClear() ;
  /*	Widget	  w ;
   *	Boolean	  redraw ;
   */

#endif /* _Canvas_h */
/* DON'T ADD STUFF AFTER THIS #endif */
