
/**********************************************************************
 * $Id: unit.h,v 1.3 92/11/30 11:32:07 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_UNIT_H
#define SIM_UNIT_H

typedef struct UnitExtensionRec	*UnitExtension ; /* BIND */
typedef void   (*UnitProc)     ARGS((Unit)) ;
typedef void   (*UnitDataProc) ARGS((Unit, ...)) ;

/***********************************************************************
 *	Definition for Unit Object record
 ***********************************************************************/
typedef struct UnitRec {	    /* BIND */
  String	name ;		    /* Name of this unit 	nosave: */
  Group		group ;		    /* group unit is in  	nsi: */
  Net		net ;		    /* net unit is in   	nsi: */

  /* Public data, feel free to change */
  Real		totalInput ;	    /* The summed input to the unit */
  Real		output ;	    /* The unit's output */
  Real		target ;	    /* The target output of the unit */
  Real		outputDeriv ;	    /* The sum of the backprop errors */
  Real		inputDeriv ;	    /* The derivative value */

  Real		*outputHistory ;    /* counter: timeSlices */
  Real		*clampingHistory ;  /* counter: timeSlices */
  Real		*targetHistory ;    /* counter: timeSlices */
  int		timeSlices ;	    /* nosave: */

  /* Best to use the utilities below to change these values */
  int		weightRow ;	    /* Used in hinton diagram display */
  int		weightColumn ;
  int		activityRow ;
  int		activityColumn ;

  Link		*incomingLink ;	    /* counter: numIncoming */
  Link		*outgoingLink ;	    /* counter: numOutgoing nosave: */
  int		numIncoming ;	    /* nosave: */
  int		numOutgoing ;	    /* nosave: */
  int		incomingArraySize ; /* nsi: */
  int		outgoingArraySize ; /* nsi: */

  /* Place to hang extra stuff if you need it */
  UnitExtension	extension ;
} UnitRec ;

/***********************************************************************
 *	Unit utilities
 ***********************************************************************/
extern void	setCreateUnitHook  ARGS((UnitProc hook)) ;
extern void	setDestroyUnitHook ARGS((UnitProc hook)) ;

extern Unit	createUnit  ARGS((String  name, Group  group)) ;
extern void	destroyUnit ARGS((Unit	unit)) ;

extern int	unitAddLink     ARGS((Unit  unit, Mask  mask, Link  link)) ;
extern void	unitDeleteLink  ARGS((Unit  unit, Mask  mask, Link  link)) ;

extern Unit	unitFromName    ARGS((Net	net, String	name)) ;
extern Unit	*unitsFromRegex ARGS((Net	net, String	regex)) ;
/***********************************************************************/

#endif				/* SIM_UNIT_H */
