
/**********************************************************************
 * $Id: qArray.h,v 1.2 92/11/30 11:31:57 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __xerion_qArray_h
#define __xerion_qArray_h

typedef struct QArray	*QArray ; /* BIND */
typedef union QArrayP {		/* BIND */
    char	*storage ;	/* NOBIND */
    float	*real ;	
} QArrayP ;

typedef struct QArray {		/* BIND */
  QArrayP	array ;
  int		bits ;
  int		elements ;
  float		min ;
  float		max ;
  
  float	(*store)	ARGS((QArray, int idx, double value)) ;	/* NOBIND */
  float	(*retrieve)	ARGS((QArray, int idx)) ; /* NOBIND */
  void	(*destroy)	ARGS((QArray)) ; /* NOBIND */
} QArrayRec ;

extern QArray	createQArray ARGS((unsigned int elements, unsigned int bits,
				   double	min,  double	   max));

extern QArray	copyQArray   ARGS((const QArray, QArray)) ;

#define MQAdestroy(q)		((q)->destroy(q))
#define MQAstore(q,i,v)		((q)->store(q, i, v))
#define MQAretrieve(q,i)	((q)->retrieve(q, i))
#define MQAelements(q)		((q)->elements)

#endif				/* __xerion_qArray_h */
