
/**********************************************************************
 * $Id: net.h,v 1.9 92/11/30 13:10:13 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_NET_H
#define SIM_NET_H

typedef struct NetExtensionRec      *NetExtension ; /* BIND */
typedef void   (*NetProc)      ARGS((Net)) ;
typedef void   (*NetErrorProc) ARGS((Net, ExampleSet)) ;
typedef void   (*NetDataProc)  ARGS((Net, ...)) ;

typedef enum LinkLayoutMode { 
  SHOW_INCOMING, SHOW_OUTGOING, SHOW_ALL
} LinkLayoutMode ;

/***********************************************************************
 *	Definition for Net Object Instance record
 ***********************************************************************/
typedef struct NetRec {		/* BIND */
  String	name ;		/* nosave: */
  Mask		type ;

  /* Public data, feel free to change */
  Real		error ;
  Real		cost ;
  int		currentEpoch ;
  int		batchSize ;

  int		minorWidth ;
  int		minorHeight ;
  int		minorMargin  ;
  int		majorWidth ;
  int		majorHeight ;
  int		majorMargin  ;
  int		activityWidth ;
  int		activityHeight ;
  int		activityMargin  ;
  LinkLayoutMode linkLayoutMode ;

  /* Actions for Nets,
   * They can be executed using the macros defined in methods.h
   */
  NetErrorProc	calculateErrorDerivProc ;
  NetErrorProc	calculateErrorProc ;
  NetProc	activityUpdateProc ;
  NetProc	gradientUpdateProc ;
  NetProc	costProc ;
  NetProc	costAndDerivsProc ;

  NetProc	otherProc ;
  
  /* Example sets. Automatically created (empty) and ready to be
   * added to.
   * Use netGetExampleSet to select a particular set
   */
  ExampleSet	trainingExampleSet ;
  ExampleSet	testingExampleSet ;
  ExampleSet	validationExampleSet ;

  /* Minimize record used by conjugate gradient minimization routines */  
  Minimize	mz ;

  /* Cost model, used to calculate network cost */  
  Real		weightCost ;		/* netParam: */
  CostModel	costModel ;

  /* Private data, it is best to use the utilities provided
   * below to set these values and traverse them as well.
   */
  Group		*group ;	 /* counter: numGroups */
  int		numGroups ;	 /* nosave: */
  int		groupArraySize ; /* nsi: */

  Real		*variables ;		/* invis: counter: numVariables */
  Real	        *gradient ;		/* invis: counter: numVariables */
  int		numVariables ;		/* nsi: */
  int		numFrozenVariables ;	/* nsi: */
  int		variableArraySize ;	/* nsi: */
  Link		*links ;		/* invis: counter: numLinks */
  int		numLinks ;		/* nsi: */
  int		numFrozenLinks ;	/* nsi: */
  int		linkArraySize ; 	/* nsi: */
  Boolean	unitGains ;

  /* used to determine how many time steps in a recurrent net */
  int		timeSlices ;	/* nosave: */
  int		currentTime ;

  /* Place to hang extra stuff if you need it */
  NetExtension	extension ;
} NetRec ;

/***********************************************************************
 *	Net utilities
 ***********************************************************************/
extern void	setCreateNetHook  ARGS((NetProc	hook)) ;
extern void	setDestroyNetHook ARGS((NetProc	hook)) ;

extern Net	createNet  ARGS((String	name, Mask mask, int timeSlices)) ;
extern void	destroyNet ARGS((Net	net)) ;

extern int	netAddGroup     ARGS((Net  net, Group  group)) ;
extern void	netDeleteGroup  ARGS((Net  net, Group  group)) ;

extern ExampleSet netGetExampleSet   ARGS((Net	net, Mask	mask)) ;

extern int	netAddLink    ARGS((Net net, Link link)) ;
extern void	netDeleteLink ARGS((Net net, Link link)) ;
extern int	netConstrainLink   ARGS((Net net, Link link, Link toLink, 
					 double scale)) ;
extern void	netUnconstrainLink ARGS((Net net, Link link)) ;
extern void	netFreezeLink   ARGS((Net net, Link link)) ;
extern void	netUnfreezeLink ARGS((Net net, Link link)) ;
/***********************************************************************/

#endif				/* SIM_NET_H */
