
/**********************************************************************
 * $Id: methods.h,v 1.3 92/11/30 11:31:52 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_METHODS_H
#define SIM_METHODS_H

/***********************************************************************
 *	General macros for doing methods with 1, 2, and 3 parameters
 ***********************************************************************/
#define M0(obj, method)			(*(obj)->method) (obj)
#define M1(obj, method, d1)		(*(obj)->method) (obj, d1)
#define M2(obj, method, d1, d2)		(*(obj)->method) (obj, d1, d2)
#define M3(obj, method, d1, d2, d3)	(*(obj)->method) (obj, d1, d2, d3)

/***********************************************************************
 *	Common macros for doing methods
 ***********************************************************************/
#define MupdateNetErrorDerivs(obj, eSet) \
  				      M1(obj, calculateErrorDerivProc, eSet)
#define MupdateNetError(obj, eSet)    M1(obj, calculateErrorProc, eSet)

#define MupdateNetActivities(obj)	M0(obj, activityUpdateProc)
#define MupdateNetGradients(obj)	M0(obj, gradientUpdateProc)

#define MupdateGroupActivities(obj)	M0(obj, groupActivityUpdateProc)
#define MupdateGroupGradients(obj)	M0(obj, groupGradientUpdateProc)

#define MupdateUnitActivity(obj)       M0(obj, group->unitActivityUpdateProc)
#define MupdateUnitGradient(obj)       M0(obj, group->unitGradientUpdateProc)

#define MevaluateCost(obj)		M0(obj, costProc)
#define MevaluateCostAndDerivs(obj)	M0(obj, costAndDerivsProc)

#define McostModel(obj)		((obj)->costModel)
#define MweightCost(net)	((net)->weightCost)
/***********************************************************************/

/***********************************************************************
 *	Example macros for doing methods
 ***********************************************************************/
#define Mreset(obj)		M0(obj, resetAction)
#define MgetNext(obj)		M0(obj, getNextAction)
#define MgetNumber(obj, n)	M1(obj, getNumberAction, n)
/***********************************************************************/

#endif				/* SIM_METHODS_H */
