
/**********************************************************************
 * $Id: mask.h,v 1.5 92/11/30 13:10:49 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_MASK_H
#define SIM_MASK_H

/* WARNING!!! THIS MAY CAUSE PROBLEMS ON 64 BIT ARCHITECTURES */
#ifndef X_H
typedef unsigned long	Mask ;
#endif

#define UNKNOWN_CLASS		"Unknown"
#define NET_CLASS		"Net"
#define EXAMPLESET_CLASS	"ExampleSet"
#define GROUP_CLASS		"Group"
#define LINK_CLASS		"Link"

/***********************************************************************
 *	Standard masks, All of these are automatically registered
 ***********************************************************************/
#define ALL		((Mask)~0)
#define UNKNOWN		((Mask)(1<<0))

#define	RECURRENT	((Mask)(1<<1))

#define	INCOMING	((Mask)(1<<1))
#define	OUTGOING	((Mask)(1<<2))
#define FROZEN		((Mask)(1<<3))
#define LOG_TRANSFORM	((Mask)(1<<4))

#define	INPUT		((Mask)(1<<1))
#define	BIAS		((Mask)(1<<2))
#define	HIDDEN		((Mask)(1<<3))
#define	OUTPUT		((Mask)(1<<4))

#define TRAINING	((Mask)(1<<1))
#define TESTING		((Mask)(1<<2))
#define VALIDATION	((Mask)(1<<3))

#define HIGHEST_BIT_USED	4
/***********************************************************************/

/***********************************************************************
 *	Routines for registering and finding masks
 ***********************************************************************/
extern Mask	registerMask	ARGS((Mask  mask, const String  name)) ;
extern Mask	findMask 	ARGS((const String name)) ;
extern String	maskName	ARGS((Mask  mask)) ;

extern Mask	registerClassMask ARGS((Mask  mask, const String class, 
					const String name)) ;
extern Mask	findClassMask     ARGS((const String class, 
					const String name)) ;
extern String	classMaskName	ARGS((const String class, Mask  mask)) ;
/***********************************************************************/

#endif				/* SIM_MASK_H */
