
/**********************************************************************
 * $Id: link.h,v 1.7 92/11/30 13:11:40 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_LINK_H
#define SIM_LINK_H

typedef struct LinkExtensionRec	*LinkExtension ; /* BIND */
typedef void   (*LinkProc)     ARGS((Link)) ;
typedef void   (*LinkDataProc) ARGS((Link, ...)) ;

/***********************************************************************
 *	Definition for Link Object Instance record
 ***********************************************************************/
typedef struct LinkRec {	/* BIND */
  String	name ;		/* nosave: */
  Mask		type ;

  Real		weight ;
  Real		deltaWeight ;
  Real		deriv ;

  Unit		preUnit ;	/* nosave: */
  Unit		postUnit ;	/* nosave: */

  /* Used for constrained connections */
  int		variableIdx ;
  Real		scaleFactor ;

  /* Used for displaying connections */
  int		weightRow[2] ;	    /* Used in hinton diagram display */
  int		weightColumn[2] ;

  /* Place to hang extra stuff if you need it */
  LinkExtension	extension ;
} LinkRec ;

/***********************************************************************
 *	Link utilities
 ***********************************************************************/
extern void	setCreateLinkHook  ARGS((LinkProc  hook)) ;
extern void	setDestroyLinkHook ARGS((LinkProc  hook)) ;
extern Link	createLink  ARGS((String  name, 
				  Unit preUnit, Unit postUnit, Mask  mask)) ;
extern void	destroyLink ARGS((Link    link)) ;

extern Real	linkSetWeight	ARGS((Link	link, double	weight)) ;
extern Link	linkFromName    ARGS((Net	net, String	name)) ;
extern Link	*linksFromRegex ARGS((Net	net, String	regex)) ;
/***********************************************************************/

/***********************************************************************
 *	Variable utilities
 ***********************************************************************/
extern Variable	createVariable	ARGS((String name, Net net, Mask mask)) ;
extern void	destroyVariable	ARGS((Variable, Net)) ;

#define variableGetValue(v)	((v)->weight) 
#define variableGetDeriv(v)	((v)->deriv) 
#define variableGetName(v)	((v)->name) 
#define variableGetType(v)	((v)->type) 
#define variableGetNet(v)	((v)->net) 

#define variableSetValue(v,x)	(linkSetWeight(v, x))
#define variableSetDeriv(v,x)	((v)->deriv  = (x))
#define variableAddToDeriv(v,x)	((v)->deriv += (x))
/***********************************************************************/

#endif				/* SIM_LINK_H */
