
/**********************************************************************
 * $Id: group.h,v 1.4 92/11/30 11:31:47 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_GROUP_H
#define SIM_GROUP_H

typedef struct GroupExtensionRec	*GroupExtension ; /* BIND */
typedef void   (*GroupProc)	ARGS((Group)) ;
typedef void   (*GroupDataProc) ARGS((Group, ...)) ;

/***********************************************************************
 *	Definition for Group Object
 ***********************************************************************/
typedef struct GroupRec {	/* BIND */
  String	name ;		/* nosave: */
  Mask		type ;
  Net		net ;		/* nsi: */

  /* Actions for Groups,
   * They can be executed using the macros defined in methods.h
   */
  GroupProc	groupActivityUpdateProc ;
  GroupProc	groupGradientUpdateProc ;
  GroupProc	groupOtherUpdateProc ;

  /* Actions for Units, All have default values.
   * They can be executed using the macros defined in methods.h
   */
  UnitProc	unitActivityUpdateProc ;
  UnitProc	unitGradientUpdateProc ;
  UnitProc	unitOtherUpdateProc ;

  /* Private data, best to use the utilities supplied below
   * to set and traverse these
   */
  Unit		*unit ;		/* counter: numUnits */
  int		numUnits ;	/* nosave: */
  int		unitArraySize ;	/* nsi: */

  /* Cost model, used to calculate network cost */  
  CostModel	costModel ;

  /* Place to hang extra stuff if you need it */
  GroupExtension	extension ;
} GroupRec ;

/***********************************************************************
 *	Group utilities
 ***********************************************************************/
extern void	setCreateGroupHook  ARGS((GroupProc hook)) ;
extern void	setDestroyGroupHook ARGS((GroupProc hook)) ;

extern Group	createGroup  ARGS((String  name, Mask  groupMask, Net  net)) ;
extern void	destroyGroup ARGS((Group  group)) ;

extern int	groupAddUnit    ARGS((Group	group, Unit	unit)) ;
extern void	groupDeleteUnit ARGS((Group	group, Unit	unit)) ;

extern Group	groupFromName     ARGS((Net  net, String  name)) ;
extern Group	*groupsFromRegex  ARGS((Net  net, String  regex)) ;
/***********************************************************************/
#endif				/* SIM_GROUP_H */
