/**********************************************************************
 * $Id: gaussian.h,v 1.5 92/11/30 11:31:44 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __xerion_gaussian_h
#define __xerion_gaussian_h

/**********************************************************************/
typedef struct Gaussian	*Gaussian ; /* BIND */
typedef struct Mixture	*Mixture ;  /* BIND */
/**********************************************************************/
typedef struct Gaussian {	/* BIND */
  /* PRIVATE */
  Real		mean ;
  Real		stdDeviation ;
  Real		variance ;
  Real		proportion ;

  Mixture	mixture ;	/* invis: */
  Boolean	changed ;	/* invis: */
  Real		density ;	/* invis: */
  Real		probability ;	/* invis: */
  Real		y ;		/* invis: */

  /* PUBLIC */
  void	(*destroy) ARGS((Gaussian)) ; 			    /* NOBIND */

  Real	(*setMean)       ARGS((Gaussian, double mean)) ;    /* NOBIND */
  Real	(*setVariance)	 ARGS((Gaussian, double variance)) ;/* NOBIND */
  Real	(*setProportion) ARGS((Gaussian, double prop)) ;    /* NOBIND */

  Real	(*getDensity)        ARGS((Gaussian, double x)) ;   /* NOBIND */
  Real	(*getProbability)    ARGS((Gaussian, double x, double delta)) ; /* NOBIND */
  Real	(*getSample)	     ARGS((Gaussian)) ;		    /* NOBIND */
  Real	(*getResponsibility) ARGS((Gaussian, double x)) ;   /* NOBIND */
} GaussianRec ;
/**********************************************************************/
Gaussian	createGaussian  ARGS((Mixture, double mean, double variance)) ;
/**********************************************************************/
#define MGdestroy(g)		(((Gaussian)(g))->destroy(g))
/**********************************************************************/
#define MGsetMean(g, x)		(((Gaussian)(g))->setMean(g, x))
#define MGsetVariance(g, x)	(((Gaussian)(g))->setVariance(g, x))
#define MGsetProportion(g, x)	(((Gaussian)(g))->setProportion(g, x))
/**********************************************************************/
#define MGmean(g)		(((Gaussian)(g))->mean)
#define MGvariance(g)		(((Gaussian)(g))->variance)
#define MGstdDeviation(g)	(((Gaussian)(g))->stdDeviation)
#define MGproportion(g)		(((Gaussian)(g))->proportion)
#define MGdensity(g, y)		(((Gaussian)(g))->getDensity(g, y))
#define MGprobability(g, y, d)	(((Gaussian)(g))->getProbability(g, y, d))
#define MGsample(g)		(((Gaussian)(g))->getSample(g))
#define MGresponsibility(g, y)	(((Gaussian)(g))->getResponsibility(g, y))
/**********************************************************************/


/**********************************************************************/
typedef struct Mixture {	/* BIND */
  /* PRIVATE */
  struct Gaussian	**gaussian ;           /* counter: numGaussians */
  int			numGaussians ; 	       /* nosave: */

  Real	   y ;		 /* invis: */
  Boolean  changed ;	 /* invis: */
  Real	   density ;	 /* invis: */

  /* PUBLIC */
  void	   (*destroy) ARGS((Mixture)) ;

  Real	(*getDensity) 		ARGS((Mixture, double y)) ; /* NOBIND */
  Real	(*getProbability)    	ARGS((Mixture, double x, double delta )) ; /* NOBIND */
  Real	(*getSample)	     	ARGS((Mixture)) ;	    /* NOBIND */

  Real	(*complexity)     ARGS((Mixture, double y)) ;	    /* NOBIND */
  Real	(*derivatives)    ARGS((Mixture, double y, Real *dCdMean, Real *dCdStdDeviation, Real *dCdProportion)) ; /* NOBIND */
} MixtureRec ;
/**********************************************************************/
Mixture	createMixture  ARGS((int numGaussians, double min, double max)) ;
/**********************************************************************/
#define MMdestroy(m)		(((Mixture)(m))->destroy(m))
/**********************************************************************/
#define MMnumGaussians(m)	(((Mixture)(m))->numGaussians)
#define MMgaussian(m, i)	(((Mixture)(m))->gaussian[i])
/**********************************************************************/
#define MMdensity(m,y)		(((Mixture)(m))->getDensity(m, y))
#define MMprobability(m, y)	(((Mixture)(m))->getProbability(m, y))
#define MMsample(m)		(((Mixture)(m))->getSample(m))
/**********************************************************************/
#define MMcomplexity(m, y)	(((Mixture)(m))->complexity(m, y))
#define MMderivatives(m, y, dm, ds, dp)	\
  (((Mixture)(m))->derivatives(m, y, dm, ds, dp))
/**********************************************************************/

#endif				/* __xerion_gaussian_h */
