
/**********************************************************************
 * $Id: example.h,v 1.9 92/11/30 11:31:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_EXAMPLE_H
#define SIM_EXAMPLE_H

typedef struct ExampleSetExtensionRec	*ExampleSetExtension ; /* BIND */
typedef struct ExampleExtensionRec	*ExampleExtension ;    /* BIND */
typedef void	(*ExampleSetProc)  ARGS((ExampleSet)) ;
typedef int	(*ResetAction)	   ARGS((ExampleSet)) ;
typedef int	(*GetNextAction)   ARGS((ExampleSet)) ;
typedef int	(*GetNumberAction) ARGS((ExampleSet, int)) ;
typedef void	(*DeleteExampleAction)	ARGS((ExampleSet, int)) ;
typedef void	(*MoveExampleAction)	ARGS((ExampleSet, int, int)) ;
typedef int	(*AddExampleListAction) ARGS((ExampleSet, int,
					      Real **, int, Real **, int)) ;
typedef int	(*GetExampleListAction) ARGS((ExampleSet, int, int *,
					      Real ***, int *, 
					      Real ***, int *)) ;

typedef struct ExampleRec {	   /* BIND */
  Real		**inputVector ;   /* counter: numVectors,numInputs */
  Real		**targetVector ;  /* counter: numVectors,numTargets */
  QArray	*inputQVector ;	  /* counter: numVectors */
  QArray	*targetQVector ;  /* counter: numVectors */
  int		numInputs ;
  int		numTargets ;
  int		numVectors ;
  String	name ;
  ExampleExtension	extension ;
} ExampleRec, *Example ;

typedef void	(*ExampleProc)	ARGS((Example)) ;

/***********************************************************************
 *	Definition for ExampleSet Object Instance record
 ***********************************************************************/
typedef struct ExampleSetRec {	   /* BIND */
  /* Standard data */
  String	name ;		   /* nosave: */
  Mask		type ;
  Net		net ;		   /* nsi: */

  /* These can be executed using the appropriate macro from
   * methods.h
   */
  ResetAction		resetAction ;
  GetNextAction		getNextAction ;
  GetNumberAction	getNumberAction ;
  AddExampleListAction	addExampleList ;
  GetExampleListAction	getExampleList ;
  DeleteExampleAction	deleteExample ;
  MoveExampleAction	moveExample ;

  /* Private data, best to use the utilities supplied below
   * to set and traverse these
   */
  ExampleRec	*example ;	   /* counter: numExamples nosave: */
  int		exampleArraySize ; /* nsi: */
  int		numExamples ;	   /* nosave: */
  int		currentIdx ;
  Mask		clampMask ;	/* mask for which units to clamp */
  Mask		targetMask ;	/* mask for which units have targets */
  int		inputBits ;
  int		targetBits ;
  Boolean	permute ;
  Real		scale ;
  Real		shift ;

  /* Place to hang extra stuff if you need it */
  ExampleSetExtension	extension ;
} ExampleSetRec ;

/***********************************************************************
 *	ExampleSet utilities
 ***********************************************************************/
extern void	  setCreateExampleSetHook  ARGS((ExampleSetProc hook)) ;
extern void	  setDestroyExampleSetHook ARGS((ExampleSetProc hook)) ;
extern ExampleSet createExampleSet   ARGS((String name, Mask mask, Net  net)) ;
extern void	  destroyExampleSet  ARGS((ExampleSet	exampleSet)) ;

extern int	  exampleSetAddExample ARGS((ExampleSet  exampleSet, 
					     Real  *input,  int  numInputs,
					     Real  *target, int  numTargets)) ;
extern int	  exampleSetAddExampleList 
  ARGS((ExampleSet  exampleSet, int	listSize,
	Real  **input,  int  numInputs,
	Real  **target, int  numTargets)) ;
extern int	  exampleSetGetExampleList 
  ARGS((ExampleSet  exampleSet, int	idx,
	int	*listSize,
	Real  ***input,  int  *numInputs,
	Real  ***target, int  *numTargets)) ;
extern void	  exampleSetDeleteExample ARGS((ExampleSet, int index)) ;
extern void	  exampleSetCopyExample	ARGS((ExampleSet, int	fromIdx,
					      ExampleSet, int	toIdx)) ;
extern void	  exampleSetMoveExample ARGS((ExampleSet, int	fromIdx,
					      ExampleSet, int	toIdx)) ;

extern void	  setCreateExampleHook  ARGS((ExampleProc hook)) ;
extern void	  setDestroyExampleHook ARGS((ExampleProc hook)) ;
extern void	  exampleSetPermute	ARGS((ExampleSet set)) ;
/***********************************************************************/
#endif				/* SIM_EXAMPLE_H */
