
/**********************************************************************
 * $Id: costModel.h,v 1.6 93/01/26 11:21:58 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __xerion_costmodel_h
#define __xerion_costmodel_h

/**********************************************************************/
typedef struct CostModel	*CostModel ;	 /* BIND */
typedef struct MixtureData	*MixtureData ;	 /* BIND */
typedef struct SumSquareData	*SumSquareData ; /* BIND */
/**********************************************************************/
typedef union	CostModelData {	/* BIND */
  MixtureData	mixtureData ;	/* nosave: */
  SumSquareData	sumSquareData ;	/* nosave: */
} CostModelData ;
/**********************************************************************/
typedef struct MixtureData {	/* BIND */
  Mixture	mixture ;
  Variable	*mean ;			/* counter: numGaussians */
  Variable	*stdDeviation ;		/* counter: numGaussians */
  Variable	*proportion ;		/* counter: numGaussians */
  int		 numGaussians ;		/* nosave: */
} MixtureDataRec ;
/**********************************************************************/
typedef struct SumSquareData {	/* BIND */
  int		foo ;
} SumSquareDataRec ;
/**********************************************************************/
typedef struct CostModel {	/* BIND */
  /* PRIVATE */
  String	 name ;
  int		 type ;
  Net		 net ;		/* nsi: */
  Link		*link ;		/* nosave: counter: numLinks */
  int		 numLinks ;	/* nosave: */
  int		 maxLinks ;	/* nsi: */

  CostModelData	costModelData ;

  /* PUBLIC */
  void	(*destroy) ARGS((CostModel)) ;

  void	(*addLink)    ARGS((CostModel, Link)) ;
  void	(*removeLink) ARGS((CostModel, Link)) ;
  
  void	(*reset)  	 	 ARGS(()) ; /* NOBIND */
  void	(*sync)  	 	 ARGS((CostModel)) ; /* NOBIND */
  Real	(*evaluateCost)  	 ARGS((CostModel, double scale)) ; /* NOBIND */
  Real	(*evaluateCostAndDerivs) ARGS((CostModel, double scale)) ; /* NOBIND */

} CostModelRec ;
/**********************************************************************/
CostModel createSumSquareCostModel ARGS((String, Net)) ;
CostModel createMixtureCostModel   ARGS((String, Net, int numGaussians, 
					 double min, double max)) ;
void	  resetMixtureCostModel    ARGS((CostModel, double min, double max)) ;
/********************************************************************/
#define CM_MIXTURE		((int)1)
#define CM_SUMSQUARE		((int)2)
/**********************************************************************/
#define MCMname(c)		  (((CostModel)(c))->name)
#define MCMtype(c)		  (((CostModel)(c))->type)
#define MCMdestroy(c)		  (((CostModel)(c))->destroy(c))
#define MCMaddLink(c, l)	  (((CostModel)(c))->addLink(c, l))
#define MCMremoveLink(c, l)	  (((CostModel)(c))->removeLink(c, l))
#define MCMsync(c)		  (((CostModel)(c))->sync(c))
#define MCMevaluateCost(c, s)	  (((CostModel)(c))->evaluateCost(c, s))
#define MCMevaluateCostAndDerivs(c, s) \
  (((CostModel)(c))->evaluateCostAndDerivs(c, s))
/**********************************************************************/

#endif				/* __xerion_costmodel_h */
